/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.user;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.auth.user.LocalFileUserManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.AuthUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileUserManagerTest {
    private File testFolder;
    private LocalFileUserManager manager;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.manager = new LocalFileUserManager(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws AuthException {
        User[] users = new User[5];
        for (int i = 0; i < users.length; ++i) {
            users[i] = new User("user" + i, "password" + i);
            for (int j = 0; j <= i; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege("root.a.b.c" + j);
                pathPrivilege.getPrivileges().add(j);
                users[i].getPrivilegeList().add(pathPrivilege);
                users[i].getRoleList().add("role" + j);
            }
        }
        User user = this.manager.getUser(users[0].getName());
        Assert.assertNull((Object)user);
        for (User user1 : users) {
            Assert.assertTrue((boolean)this.manager.createUser(user1.getName(), user1.getPassword()));
        }
        for (User user1 : users) {
            user = this.manager.getUser(user1.getName());
            Assert.assertEquals((Object)user1.getName(), (Object)user.getName());
            Assert.assertEquals((Object)AuthUtils.encryptPassword((String)user1.getPassword()), (Object)user.getPassword());
        }
        Assert.assertFalse((boolean)this.manager.createUser(users[0].getName(), users[0].getPassword()));
        boolean caught = false;
        try {
            this.manager.createUser("too", "short");
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            this.manager.createUser("short", "too");
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertFalse((boolean)this.manager.deleteUser("not a user"));
        Assert.assertTrue((boolean)this.manager.deleteUser(users[users.length - 1].getName()));
        Assert.assertNull((Object)this.manager.getUser(users[users.length - 1].getName()));
        Assert.assertFalse((boolean)this.manager.deleteUser(users[users.length - 1].getName()));
        user = this.manager.getUser(users[0].getName());
        String path = "root.a.b.c";
        int privilegeId = 0;
        Assert.assertFalse((boolean)user.hasPrivilege(path, privilegeId));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId));
        Assert.assertTrue((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId + 1));
        Assert.assertFalse((boolean)this.manager.grantPrivilegeToUser(user.getName(), path, privilegeId));
        user = this.manager.getUser(users[0].getName());
        Assert.assertTrue((boolean)user.hasPrivilege(path, privilegeId));
        caught = false;
        try {
            this.manager.grantPrivilegeToUser("not a user", path, privilegeId);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            this.manager.grantPrivilegeToUser(user.getName(), path, -1);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        user = this.manager.getUser(users[0].getName());
        Assert.assertTrue((boolean)this.manager.revokePrivilegeFromUser(user.getName(), path, privilegeId));
        Assert.assertFalse((boolean)this.manager.revokePrivilegeFromUser(user.getName(), path, privilegeId));
        caught = false;
        try {
            this.manager.revokePrivilegeFromUser("not a user", path, privilegeId);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        caught = false;
        try {
            this.manager.revokePrivilegeFromUser(user.getName(), path, -1);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        String newPassword = "newPassword";
        String illegalPW = "new";
        Assert.assertTrue((boolean)this.manager.updateUserPassword(user.getName(), newPassword));
        Assert.assertFalse((boolean)this.manager.updateUserPassword(user.getName(), illegalPW));
        user = this.manager.getUser(user.getName());
        Assert.assertEquals((Object)AuthUtils.encryptPassword((String)newPassword), (Object)user.getPassword());
        caught = false;
        try {
            this.manager.updateUserPassword("not a user", newPassword);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        String roleName = "newrole";
        Assert.assertTrue((boolean)this.manager.grantRoleToUser(roleName, user.getName()));
        Assert.assertFalse((boolean)this.manager.grantRoleToUser(roleName, user.getName()));
        user = this.manager.getUser(user.getName());
        Assert.assertTrue((boolean)user.hasRole(roleName));
        caught = false;
        try {
            this.manager.grantRoleToUser("not a user", roleName);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)this.manager.revokeRoleFromUser(roleName, user.getName()));
        Assert.assertFalse((boolean)this.manager.revokeRoleFromUser(roleName, user.getName()));
        user = this.manager.getUser(user.getName());
        Assert.assertFalse((boolean)user.hasRole(roleName));
        caught = false;
        try {
            this.manager.revokeRoleFromUser("not a user", roleName);
        }
        catch (AuthException e) {
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        List usernames = this.manager.listAllUsers();
        usernames.sort(null);
        Assert.assertEquals((Object)IoTDBDescriptor.getInstance().getConfig().getAdminName(), usernames.get(0));
        for (int i = 0; i < users.length - 1; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i + 1));
        }
    }
}

