/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.upgrade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkGroupMetaDataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDeviceMetadataIndexV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDeviceMetadataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsFileMetadataV1;
import org.apache.iotdb.tsfile.v1.file.utils.HeaderUtils;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOnlineUpgradeTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOnlineUpgradeTool.class);
    private TsFileInput tsFileInput;
    private long fileMetadataPos;
    private int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    private Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private Decoder valueDecoder;
    protected String file;
    private Map<Long, TsFileIOWriter> partitionWriterMap;

    public TsFileOnlineUpgradeTool(String file) throws IOException {
        this(file, true);
    }

    public TsFileOnlineUpgradeTool(String file, boolean loadMetadataSize) throws IOException {
        this.file = file;
        this.tsFileInput = FSFactoryProducer.getFileInputFactory().getTsFileInput(file);
        this.partitionWriterMap = new HashMap<Long, TsFileIOWriter>();
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize();
            }
        }
        catch (Exception e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public static void upgradeOneTsfile(String tsFileName, List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        try (TsFileOnlineUpgradeTool updater = new TsFileOnlineUpgradeTool(tsFileName);){
            updater.upgradeFile(upgradedResources);
        }
    }

    public void loadMetadataSize() throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
        metadataSize.flip();
        this.fileMetadataSize = ReadWriteIOUtils.readInt((ByteBuffer)metadataSize);
        this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        this.position("TsFile".length());
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".length());
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFile".length());
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        return this.tsFileInput.size() >= (long)("TsFile".length() * 2) && this.readTailMagic().equals(this.readHeadMagic());
    }

    public String readHeadMagic() throws IOException {
        return this.readHeadMagic(false);
    }

    public String readHeadMagic(boolean movePosition) throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFile".length());
        if (movePosition) {
            this.tsFileInput.position(0L);
            this.tsFileInput.read(magicStringBytes);
        } else {
            this.tsFileInput.read(magicStringBytes, 0L);
        }
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public String readVersionNumber() throws IOException {
        ByteBuffer versionNumberBytes = ByteBuffer.allocate("000002".getBytes().length);
        this.tsFileInput.position((long)"TsFile".getBytes().length);
        this.tsFileInput.read(versionNumberBytes);
        versionNumberBytes.flip();
        return new String(versionNumberBytes.array());
    }

    public TsFileMetadataV1 readFileMetadata() throws IOException {
        return TsFileMetadataV1.deserializeFrom((ByteBuffer)this.readData(this.fileMetadataPos, this.fileMetadataSize));
    }

    public TsDeviceMetadataV1 readTsDeviceMetaData(TsDeviceMetadataIndexV1 index) throws IOException {
        return TsDeviceMetadataV1.deserializeFrom((ByteBuffer)this.readData(index.getOffset(), index.getLen()));
    }

    public ChunkGroupFooter readChunkGroupFooter() throws IOException {
        return ChunkGroupFooter.deserializeFrom((InputStream)this.tsFileInput.wrapAsInputStream(), (boolean)true);
    }

    public ChunkHeader readChunkHeader() throws IOException {
        return HeaderUtils.deserializeChunkHeaderV1((InputStream)this.tsFileInput.wrapAsInputStream(), (boolean)true);
    }

    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return HeaderUtils.deserializePageHeaderV1((InputStream)this.tsFileInput.wrapAsInputStream(), (TSDataType)type);
    }

    public ByteBuffer readPage(PageHeader header, CompressionType type) throws IOException {
        ByteBuffer buffer = this.readData(-1L, header.getCompressedSize());
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)type);
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(header.getUncompressedSize());
        if (type == CompressionType.UNCOMPRESSED) {
            return buffer;
        }
        unCompressor.uncompress(buffer.array(), buffer.position(), buffer.remaining(), uncompressedBuffer.array(), 0);
        return uncompressedBuffer;
    }

    public ByteBuffer readCompressedPage(PageHeader header) throws IOException {
        return this.readData(-1L, header.getCompressedSize());
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible((TsFileInput)this.tsFileInput, (ByteBuffer)this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    public byte readMarker(long position) throws IOException {
        return this.readData(position, 1).get();
    }

    @Override
    public void close() throws IOException {
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    private ByteBuffer readData(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position == -1L ? ReadWriteIOUtils.readAsPossible((TsFileInput)this.tsFileInput, (ByteBuffer)buffer) != size : ReadWriteIOUtils.readAsPossible((TsFileInput)this.tsFileInput, (ByteBuffer)buffer, (long)position, (int)size) != size) {
            throw new IOException("reach the end of the data");
        }
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeFile(List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        File oldTsFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!this.fileCheck(oldTsFile)) {
            return;
        }
        Map<Long, Long> oldVersionInfo = this.getVersionInfo();
        long startOffsetOfChunkGroup = 0L;
        boolean newChunkGroup = true;
        long versionOfChunkGroup = 0L;
        int chunkGroupCount = 0;
        ArrayList<List<PageHeader>> pageHeadersInChunkGroup = new ArrayList<List<PageHeader>>();
        ArrayList<List<ByteBuffer>> pageDataInChunkGroup = new ArrayList<List<ByteBuffer>>();
        ArrayList<List<Boolean>> pagePartitionInfoInChunkGroup = new ArrayList<List<Boolean>>();
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        try {
            byte marker;
            block10: while ((marker = this.readMarker()) != 2) {
                switch (marker) {
                    case 1: {
                        if (newChunkGroup) {
                            newChunkGroup = false;
                            startOffsetOfChunkGroup = this.position() - 1L;
                            versionOfChunkGroup = oldVersionInfo.get(startOffsetOfChunkGroup);
                        }
                        ChunkHeader header = this.readChunkHeader();
                        MeasurementSchema measurementSchema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        ArrayList<PageHeader> pageHeadersInChunk = new ArrayList<PageHeader>();
                        ArrayList<ByteBuffer> dataInChunk = new ArrayList<ByteBuffer>();
                        ArrayList<Boolean> pagePartitionInfo = new ArrayList<Boolean>();
                        for (int j = 0; j < header.getNumOfPages(); ++j) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            boolean pageInSamePartition = this.checkIfPageInSameTimePartition(pageHeader);
                            pagePartitionInfo.add(pageInSamePartition);
                            ByteBuffer pageData = pageInSamePartition ? this.readCompressedPage(pageHeader) : this.readPage(pageHeader, header.getCompressionType());
                            pageHeadersInChunk.add(pageHeader);
                            dataInChunk.add(pageData);
                        }
                        pageHeadersInChunkGroup.add(pageHeadersInChunk);
                        pageDataInChunkGroup.add(dataInChunk);
                        pagePartitionInfoInChunkGroup.add(pagePartitionInfo);
                        continue block10;
                    }
                    case 0: {
                        ChunkGroupFooter chunkGroupFooter = this.readChunkGroupFooter();
                        String deviceID = chunkGroupFooter.getDeviceID();
                        this.rewrite(oldTsFile, deviceID, measurementSchemaList, pageHeadersInChunkGroup, pageDataInChunkGroup, versionOfChunkGroup, pagePartitionInfoInChunkGroup);
                        pageHeadersInChunkGroup.clear();
                        pageDataInChunkGroup.clear();
                        measurementSchemaList.clear();
                        pagePartitionInfoInChunkGroup.clear();
                        newChunkGroup = true;
                        ++chunkGroupCount;
                        continue block10;
                    }
                }
                logger.error("Unrecognized marker detected, this file may be corrupted");
                return;
            }
            for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                upgradedResources.add(this.endFileAndGenerateResource(tsFileIOWriter));
            }
        }
        catch (IOException e2) {
            logger.info("TsFile upgrade process cannot proceed at position {} after {} chunk groups recovered, because : {}", new Object[]{this.position(), chunkGroupCount, e2.getMessage()});
        }
        finally {
            if (this.tsFileInput != null) {
                this.tsFileInput.close();
            }
        }
    }

    private boolean checkIfPageInSameTimePartition(PageHeader pageHeader) {
        return StorageEngine.getTimePartition(pageHeader.getStartTime()) == StorageEngine.getTimePartition(pageHeader.getEndTime());
    }

    private void rewrite(File oldTsFile, String deviceId, List<MeasurementSchema> schemas, List<List<PageHeader>> pageHeadersInChunkGroup, List<List<ByteBuffer>> dataInChunkGroup, long versionOfChunkGroup, List<List<Boolean>> pagePartitionInfoInChunkGroup) throws IOException, PageException {
        HashMap<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup = new HashMap<Long, Map<MeasurementSchema, ChunkWriterImpl>>();
        for (int i = 0; i < schemas.size(); ++i) {
            MeasurementSchema schema = schemas.get(i);
            List<ByteBuffer> pageDataInChunk = dataInChunkGroup.get(i);
            List<PageHeader> pageHeadersInChunk = pageHeadersInChunkGroup.get(i);
            List<Boolean> pagePartitionInfo = pagePartitionInfoInChunkGroup.get(i);
            this.valueDecoder = Decoder.getDecoderByType((TSEncoding)schema.getEncodingType(), (TSDataType)schema.getType());
            for (int j = 0; j < pageDataInChunk.size(); ++j) {
                if (Boolean.TRUE.equals(pagePartitionInfo.get(j))) {
                    this.writePageInSamePartitionToFile(oldTsFile, schema, pageHeadersInChunk.get(j), pageDataInChunk.get(j), chunkWritersInChunkGroup);
                    continue;
                }
                this.writePageInDifferentPartitionsToFiles(oldTsFile, schema, pageDataInChunk.get(j), chunkWritersInChunkGroup);
            }
        }
        for (Map.Entry entry : chunkWritersInChunkGroup.entrySet()) {
            long partitionId = (Long)entry.getKey();
            TsFileIOWriter tsFileIOWriter = this.partitionWriterMap.get(partitionId);
            tsFileIOWriter.startChunkGroup(deviceId);
            for (IChunkWriter chunkWriter : ((Map)entry.getValue()).values()) {
                chunkWriter.writeToFileWriter(tsFileIOWriter);
            }
            tsFileIOWriter.endChunkGroup();
            tsFileIOWriter.writeVersion(versionOfChunkGroup);
        }
    }

    private TsFileIOWriter getOrDefaultTsFileIOWriter(File oldTsFile, long partition) {
        return this.partitionWriterMap.computeIfAbsent(partition, k -> {
            File partitionDir = FSFactoryProducer.getFSFactory().getFile(oldTsFile.getParent() + File.separator + partition);
            if (!partitionDir.exists()) {
                partitionDir.mkdirs();
            }
            File newFile = FSFactoryProducer.getFSFactory().getFile(oldTsFile.getParent() + File.separator + partition + File.separator + oldTsFile.getName());
            try {
                if (!newFile.createNewFile()) {
                    logger.error("The TsFile {} has been created ", (Object)newFile);
                    return null;
                }
                return new TsFileIOWriter(newFile);
            }
            catch (IOException e) {
                logger.error("Create new TsFile {} failed ", (Object)newFile);
                return null;
            }
        });
    }

    private void writePageInSamePartitionToFile(File oldTsFile, MeasurementSchema schema, PageHeader pageHeader, ByteBuffer pageData, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) throws PageException {
        long partitionId = StorageEngine.getTimePartition(pageHeader.getStartTime());
        this.getOrDefaultTsFileIOWriter(oldTsFile, partitionId);
        Map chunkWriters = chunkWritersInChunkGroup.getOrDefault(partitionId, new HashMap());
        ChunkWriterImpl chunkWriter = chunkWriters.getOrDefault(schema, new ChunkWriterImpl(schema));
        chunkWriter.writePageHeaderAndDataIntoBuff(pageData, pageHeader);
        chunkWriters.put(schema, chunkWriter);
        chunkWritersInChunkGroup.put(partitionId, chunkWriters);
    }

    private void writePageInDifferentPartitionsToFiles(File oldTsFile, MeasurementSchema schema, ByteBuffer pageData, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) throws IOException {
        this.valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        while (batchData.hasCurrent()) {
            long time = batchData.currentTime();
            Object value = batchData.currentValue();
            long partitionId = StorageEngine.getTimePartition(time);
            Map chunkWriters = chunkWritersInChunkGroup.getOrDefault(partitionId, new HashMap());
            ChunkWriterImpl chunkWriter = chunkWriters.getOrDefault(schema, new ChunkWriterImpl(schema));
            this.getOrDefaultTsFileIOWriter(oldTsFile, partitionId);
            switch (schema.getType()) {
                case INT32: {
                    chunkWriter.write(time, ((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    chunkWriter.write(time, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(time, ((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(time, ((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(time, ((Boolean)value).booleanValue());
                    break;
                }
                case TEXT: {
                    chunkWriter.write(time, (Binary)value);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", schema.getType()));
                }
            }
            batchData.next();
            chunkWriters.put(schema, chunkWriter);
            chunkWritersInChunkGroup.put(partitionId, chunkWriters);
        }
    }

    private boolean fileCheck(File oldTsFile) throws IOException {
        if (!oldTsFile.exists()) {
            logger.error("the file to be updated does not exist, file path: {}", (Object)oldTsFile.getPath());
            return false;
        }
        long fileSize = oldTsFile.length();
        String magic = this.readHeadMagic(true);
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)oldTsFile.getPath());
            return false;
        }
        String versionNumber = this.readVersionNumber();
        if (!versionNumber.equals("000001")) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)oldTsFile.getPath());
            return false;
        }
        if (fileSize == (long)"TsFile".length()) {
            logger.error("the file only contains magic string, file path: {}", (Object)oldTsFile.getPath());
            return false;
        }
        if (!this.readTailMagic().equals("TsFile")) {
            logger.error("the file cannot upgrade, file path: {}", (Object)oldTsFile.getPath());
            return false;
        }
        return true;
    }

    private Map<Long, Long> getVersionInfo() throws IOException {
        HashMap<Long, Long> versionInfo = new HashMap<Long, Long>();
        TsFileMetadataV1 fileMetadata = this.readFileMetadata();
        ArrayList<TsDeviceMetadataV1> oldDeviceMetadataList = new ArrayList<TsDeviceMetadataV1>();
        for (TsDeviceMetadataIndexV1 index : fileMetadata.getDeviceMap().values()) {
            TsDeviceMetadataV1 oldDeviceMetadata = this.readTsDeviceMetaData(index);
            oldDeviceMetadataList.add(oldDeviceMetadata);
        }
        for (TsDeviceMetadataV1 oldTsDeviceMetadata : oldDeviceMetadataList) {
            for (ChunkGroupMetaDataV1 oldChunkGroupMetadata : oldTsDeviceMetadata.getChunkGroupMetaDataList()) {
                long version = oldChunkGroupMetadata.getVersion();
                long offsetOfChunkGroup = oldChunkGroupMetadata.getStartOffsetOfChunkGroup();
                versionInfo.put(offsetOfChunkGroup, version);
            }
        }
        return versionInfo;
    }

    private TsFileResource endFileAndGenerateResource(TsFileIOWriter tsFileIOWriter) throws IOException {
        tsFileIOWriter.endFile();
        TsFileResource tsFileResource = new TsFileResource(tsFileIOWriter.getFile());
        Map deviceTimeseriesMetadataMap = tsFileIOWriter.getDeviceTimeseriesMetadataMap();
        for (Map.Entry entry : deviceTimeseriesMetadataMap.entrySet()) {
            String device = (String)entry.getKey();
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime(device, timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(device, timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.setClosed(true);
        return tsFileResource;
    }
}

