/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;

public class LocalGroupByExecutor
implements GroupByExecutor {
    private final IAggregateReader reader;
    private BatchData preCachedData;
    private final List<AggregateResult> results = new ArrayList<AggregateResult>();
    private final TimeRange timeRange;
    private int lastReadCurArrayIndex;
    private int lastReadCurListIndex;
    private boolean ascending;
    private QueryDataSource queryDataSource;

    public LocalGroupByExecutor(PartialPath path, Set<String> allSensors, TSDataType dataType, QueryContext context, Filter timeFilter, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, QueryProcessException {
        this.queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter);
        timeFilter = this.queryDataSource.updateFilterUsingTTL(timeFilter);
        this.reader = new SeriesAggregateReader(path, allSensors, dataType, context, this.queryDataSource, timeFilter, null, fileFilter, ascending);
        this.preCachedData = null;
        this.timeRange = new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE);
        this.lastReadCurArrayIndex = 0;
        this.lastReadCurListIndex = 0;
        this.ascending = ascending;
    }

    public boolean isEmpty() {
        return this.queryDataSource.getSeqResources().isEmpty() && this.queryDataSource.getUnseqResources().isEmpty();
    }

    @Override
    public void addAggregateResult(AggregateResult aggrResult) {
        this.results.add(aggrResult);
    }

    private boolean isEndCalc() {
        for (AggregateResult result : this.results) {
            if (result.hasFinalResult()) continue;
            return false;
        }
        return true;
    }

    private boolean calcFromCacheData(long curStartTime, long curEndTime) throws IOException {
        this.calcFromBatch(this.preCachedData, curStartTime, curEndTime);
        return this.preCachedData != null && (!this.ascending ? this.preCachedData.getMinTimestamp() < curStartTime : this.preCachedData.getMaxTimestamp() >= curEndTime) || this.isEndCalc();
    }

    private void calcFromBatch(BatchData batchData, long curStartTime, long curEndTime) throws IOException {
        if (!this.satisfied(batchData, curStartTime, curEndTime)) {
            return;
        }
        for (AggregateResult result : this.results) {
            if (result.hasFinalResult()) continue;
            batchData.resetBatchData(this.lastReadCurArrayIndex, this.lastReadCurListIndex);
            if (this.ascending) {
                while (batchData.hasCurrent() && batchData.currentTime() < curStartTime) {
                    batchData.next();
                }
            } else {
                while (batchData.hasCurrent() && batchData.currentTime() >= curEndTime) {
                    batchData.next();
                }
            }
            if (!batchData.hasCurrent()) continue;
            result.updateResultFromPageData(batchData, curStartTime, curEndTime);
        }
        this.lastReadCurArrayIndex = batchData.getReadCurArrayIndex();
        this.lastReadCurListIndex = batchData.getReadCurListIndex();
        if (batchData.hasCurrent()) {
            this.preCachedData = batchData;
        }
    }

    private boolean satisfied(BatchData batchData, long curStartTime, long curEndTime) {
        if (batchData == null || !batchData.hasCurrent()) {
            return false;
        }
        if (this.ascending && (batchData.getMaxTimestamp() < curStartTime || batchData.currentTime() >= curEndTime)) {
            return false;
        }
        if (!(this.ascending || batchData.getTimeByIndex(0) < curEndTime && batchData.currentTime() >= curStartTime)) {
            this.preCachedData = batchData;
            return false;
        }
        return true;
    }

    private void calcFromStatistics(Statistics pageStatistics) throws QueryProcessException {
        for (AggregateResult result : this.results) {
            if (result.hasFinalResult()) continue;
            result.updateResultFromStatistics(pageStatistics);
        }
    }

    @Override
    public List<AggregateResult> calcResult(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        for (AggregateResult result : this.results) {
            result.reset();
        }
        this.timeRange.set(curStartTime, curEndTime - 1L);
        if (this.calcFromCacheData(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromPage(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromChunk(curStartTime, curEndTime)) {
            return this.results;
        }
        while (this.reader.hasNextFile()) {
            Statistics fileStatistics = this.reader.currentFileStatistics();
            if (fileStatistics.getStartTime() >= curEndTime) {
                return this.results;
            }
            if (this.reader.canUseCurrentFileStatistics() && this.timeRange.contains(fileStatistics.getStartTime(), fileStatistics.getEndTime())) {
                this.calcFromStatistics(fileStatistics);
                this.reader.skipCurrentFile();
                continue;
            }
            if (!this.readAndCalcFromChunk(curStartTime, curEndTime)) continue;
            return this.results;
        }
        return this.results;
    }

    @Override
    public Pair<Long, Object> peekNextNotNullValue(long nextStartTime, long nextEndTime) throws IOException {
        try {
            if (this.preCachedData != null && this.preCachedData.hasCurrent()) {
                int readCurArrayIndex = this.preCachedData.getReadCurArrayIndex();
                int readCurListIndex = this.preCachedData.getReadCurListIndex();
                List<AggregateResult> aggregateResults = this.calcResult(nextStartTime, nextEndTime);
                if (aggregateResults == null || aggregateResults.get(0).getResult() == null) {
                    return null;
                }
                this.lastReadCurListIndex = readCurListIndex;
                this.lastReadCurArrayIndex = readCurArrayIndex;
                this.preCachedData.resetBatchData(readCurArrayIndex, readCurListIndex);
                return new Pair((Object)nextStartTime, aggregateResults.get(0).getResult());
            }
            int readCurArrayIndex = this.lastReadCurArrayIndex;
            int readCurListIndex = this.lastReadCurListIndex;
            List<AggregateResult> aggregateResults = this.calcResult(nextStartTime, nextEndTime);
            if (aggregateResults == null || aggregateResults.get(0).getResult() == null) {
                return null;
            }
            this.lastReadCurListIndex = readCurListIndex;
            this.lastReadCurArrayIndex = readCurArrayIndex;
            if (this.preCachedData != null) {
                this.preCachedData.resetBatchData();
            }
            return new Pair((Object)nextStartTime, aggregateResults.get(0).getResult());
        }
        catch (QueryProcessException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private boolean readAndCalcFromChunk(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextChunk()) {
            Statistics chunkStatistics = this.reader.currentChunkStatistics();
            if (chunkStatistics.getStartTime() >= curEndTime) {
                if (this.ascending) {
                    return true;
                }
                this.reader.skipCurrentChunk();
                continue;
            }
            if (this.reader.canUseCurrentChunkStatistics() && this.timeRange.contains(chunkStatistics.getStartTime(), chunkStatistics.getEndTime())) {
                this.calcFromStatistics(chunkStatistics);
                this.reader.skipCurrentChunk();
                continue;
            }
            if (!this.readAndCalcFromPage(curStartTime, curEndTime)) continue;
            return true;
        }
        return false;
    }

    private boolean readAndCalcFromPage(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextPage()) {
            BatchData batchData;
            Statistics pageStatistics = this.reader.currentPageStatistics();
            if (pageStatistics != null) {
                if (pageStatistics.getStartTime() >= curEndTime) {
                    if (this.ascending) {
                        return true;
                    }
                    this.reader.skipCurrentPage();
                    continue;
                }
                if (this.reader.canUseCurrentPageStatistics() && this.timeRange.contains(pageStatistics.getStartTime(), pageStatistics.getEndTime())) {
                    this.calcFromStatistics(pageStatistics);
                    this.reader.skipCurrentPage();
                    if (!this.isEndCalc()) continue;
                    return true;
                }
            }
            if ((batchData = this.reader.nextPage()) == null || !batchData.hasCurrent()) continue;
            if (this.ascending && batchData.currentTime() >= curEndTime) {
                this.preCachedData = batchData;
                return true;
            }
            this.lastReadCurArrayIndex = batchData.getReadCurArrayIndex();
            this.lastReadCurListIndex = batchData.getReadCurListIndex();
            this.calcFromBatch(batchData, curStartTime, curEndTime);
            if (!this.isEndCalc() && (!batchData.hasCurrent() || !(this.ascending ? batchData.currentTime() >= curEndTime : batchData.currentTime() < curStartTime))) continue;
            return true;
        }
        return false;
    }
}

