/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class GroupByEngineDataSet
extends QueryDataSet {
    protected long queryId;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;
    protected long curStartTime;
    protected long curEndTime;
    protected boolean hasCachedTimeInterval;
    protected boolean leftCRightO;

    public GroupByEngineDataSet() {
    }

    public GroupByEngineDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(new ArrayList<PartialPath>(groupByTimePlan.getDeduplicatedPaths()), groupByTimePlan.getDeduplicatedDataTypes(), groupByTimePlan.isAscending());
        this.queryId = context.getQueryId();
        this.interval = groupByTimePlan.getInterval();
        this.slidingStep = groupByTimePlan.getSlidingStep();
        this.startTime = groupByTimePlan.getStartTime();
        this.endTime = groupByTimePlan.getEndTime();
        this.leftCRightO = groupByTimePlan.isLeftCRightO();
        this.ascending = groupByTimePlan.isAscending();
        if (this.ascending) {
            this.curStartTime = this.startTime;
        } else {
            long queryRange = this.endTime - this.startTime;
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
            this.curStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
        }
        this.curEndTime = Math.min(this.curStartTime + this.interval, this.endTime);
        this.hasCachedTimeInterval = true;
    }

    protected boolean hasNextWithoutConstraint() {
        if (this.hasCachedTimeInterval) {
            return true;
        }
        if (this.ascending) {
            this.curStartTime += this.slidingStep;
            if (this.curStartTime >= this.endTime) {
                return false;
            }
        } else {
            this.curStartTime -= this.slidingStep;
            if (this.curStartTime < this.startTime) {
                return false;
            }
        }
        this.hasCachedTimeInterval = true;
        this.curEndTime = Math.min(this.curStartTime + this.interval, this.endTime);
        return true;
    }

    protected abstract RowRecord nextWithoutConstraint() throws IOException;

    public long getStartTime() {
        return this.startTime;
    }

    public Pair<Long, Long> nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return new Pair((Object)this.curStartTime, (Object)this.curEndTime);
    }

    public abstract Pair<Long, Object> peekNextNotNullValue(Path var1, int var2) throws IOException;
}

