/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowTimeseriesDataSet
extends QueryDataSet {
    private static final Logger logger = LoggerFactory.getLogger(ShowTimeseriesDataSet.class);
    private final ShowTimeSeriesPlan plan;
    private List<RowRecord> result = new ArrayList<RowRecord>();
    private int index = 0;
    private QueryContext context;
    public boolean hasLimit;
    private static Path[] resourcePaths = new Path[]{new PartialPath("timeseries", false), new PartialPath("alias", false), new PartialPath("storage group", false), new PartialPath("dataType", false), new PartialPath("encoding", false), new PartialPath("compression", false), new PartialPath("tags", false), new PartialPath("attributes", false)};
    private static TSDataType[] resourceTypes = new TSDataType[]{TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT};

    public ShowTimeseriesDataSet(ShowTimeSeriesPlan showTimeSeriesPlan, QueryContext context) throws MetadataException {
        super(Arrays.asList(resourcePaths), Arrays.asList(resourceTypes));
        this.plan = showTimeSeriesPlan;
        this.context = context;
        this.hasLimit = this.plan.hasLimit();
        this.getQueryDataSet();
    }

    public List<RowRecord> getQueryDataSet() throws MetadataException {
        List<ShowTimeSeriesResult> timeseriesList = IoTDB.metaManager.showTimeseries(this.plan, this.context);
        ArrayList<RowRecord> records = new ArrayList<RowRecord>();
        for (ShowTimeSeriesResult result : timeseriesList) {
            RowRecord record = new RowRecord(0L);
            this.updateRecord(record, result.getName());
            this.updateRecord(record, result.getAlias());
            this.updateRecord(record, result.getSgName());
            this.updateRecord(record, result.getDataType().toString());
            this.updateRecord(record, result.getEncoding().toString());
            this.updateRecord(record, result.getCompressor().toString());
            this.updateRecord(record, result.getTag());
            this.updateRecord(record, result.getAttribute());
            records.add(record);
            this.putRecord(record);
        }
        return records;
    }

    private void updateRecord(RowRecord record, Map<String, String> map) {
        String text = map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
        this.updateRecord(record, text.length() == 0 ? null : "{" + text + "}");
    }

    private void updateRecord(RowRecord record, String s) {
        if (s == null) {
            record.addField(null);
            return;
        }
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(s));
        record.addField(field);
    }

    protected boolean hasNextWithoutConstraint() throws IOException {
        if (this.index == this.result.size() && !this.hasLimit && this.result.size() == this.plan.getLimit()) {
            this.plan.setOffset(this.plan.getOffset() + this.plan.getLimit());
            try {
                this.result = this.getQueryDataSet();
                this.index = 0;
            }
            catch (MetadataException e) {
                throw new IOException(e);
            }
        }
        return this.index < this.result.size();
    }

    protected RowRecord nextWithoutConstraint() {
        return this.result.get(this.index++);
    }

    private void putRecord(RowRecord newRecord) {
        this.result.add(newRecord);
    }
}

