/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinTimeAggrResult
extends AggregateResult {
    public MinTimeAggrResult() {
        super(TSDataType.INT64, AggregationType.MIN_TIME);
        this.reset();
    }

    @Override
    public Long getResult() {
        return this.hasCandidateResult() ? Long.valueOf(this.getLongValue()) : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        long time = statistics.getStartTime();
        this.setValue(time);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage) {
        this.updateResultFromPageData(dataInThisPage, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(BatchData dataInThisPage, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        if (dataInThisPage.hasCurrent() && dataInThisPage.currentTime() < maxBound && dataInThisPage.currentTime() >= minBound) {
            this.setLongValue(dataInThisPage.currentTime());
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        if (this.hasFinalResult()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.setLongValue(timestamps[i]);
            return;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public void merge(AggregateResult another) {
        MinTimeAggrResult anotherMinTime = (MinTimeAggrResult)another;
        if (!this.hasCandidateResult() && anotherMinTime.hasCandidateResult()) {
            this.setLongValue(anotherMinTime.getResult());
            return;
        }
        if (this.hasCandidateResult() && anotherMinTime.hasCandidateResult() && this.getResult() > anotherMinTime.getResult()) {
            this.setLongValue(anotherMinTime.getResult());
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }
}

