/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class InsertPlan
extends PhysicalPlan {
    protected PartialPath deviceId;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected MeasurementMNode[] measurementMNodes;
    List<String> failedMeasurements;
    private List<Exception> failedExceptions;
    private List<Integer> failedIndices;

    public InsertPlan(Operator.OperatorType operatorType) {
        super(false, operatorType);
        this.canBeSplit = false;
    }

    public PartialPath getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(PartialPath deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public MeasurementMNode[] getMeasurementMNodes() {
        return this.measurementMNodes;
    }

    public void setMeasurementMNodes(MeasurementMNode[] mNodes) {
        this.measurementMNodes = mNodes;
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurements;
    }

    public List<Exception> getFailedExceptions() {
        return this.failedExceptions;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurements == null ? 0 : this.failedMeasurements.size();
    }

    public abstract long getMinTime();

    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurements == null) {
            this.failedMeasurements = new ArrayList<String>();
            this.failedExceptions = new ArrayList<Exception>();
            this.failedIndices = new ArrayList<Integer>();
        }
        this.failedMeasurements.add(this.measurements[index]);
        this.failedExceptions.add(e);
        this.failedIndices.add(index);
        this.measurements[index] = null;
        this.dataTypes[index] = null;
    }

    public InsertPlan getPlanFromFailed() {
        int i;
        Object[] temp;
        if (this.failedMeasurements == null) {
            return null;
        }
        this.measurements = this.failedMeasurements.toArray(new String[0]);
        this.failedMeasurements = null;
        if (this.dataTypes != null) {
            temp = (TSDataType[])this.dataTypes.clone();
            this.dataTypes = new TSDataType[this.failedIndices.size()];
            for (i = 0; i < this.failedIndices.size(); ++i) {
                this.dataTypes[i] = temp[this.failedIndices.get(i)];
            }
        }
        if (this.measurementMNodes != null) {
            temp = (MeasurementMNode[])this.measurementMNodes.clone();
            this.measurementMNodes = new MeasurementMNode[this.failedIndices.size()];
            for (i = 0; i < this.failedIndices.size(); ++i) {
                this.measurementMNodes[i] = temp[this.failedIndices.get(i)];
            }
        }
        this.failedIndices = null;
        this.failedExceptions = null;
        return this;
    }
}

