/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;

public final class SelectOperator
extends Operator {
    private List<PartialPath> suffixList;
    private List<String> aggregations;
    private boolean lastQuery;

    public SelectOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.SELECT;
        this.suffixList = new ArrayList<PartialPath>();
        this.aggregations = new ArrayList<String>();
        this.lastQuery = false;
    }

    public void addSelectPath(PartialPath suffixPath) {
        this.suffixList.add(suffixPath);
    }

    public void addClusterPath(PartialPath suffixPath, String aggregation) {
        this.suffixList.add(suffixPath);
        this.aggregations.add(aggregation);
    }

    public void setLastQuery() {
        this.lastQuery = true;
    }

    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations;
    }

    public void setSuffixPathList(List<PartialPath> suffixPaths) {
        this.suffixList = suffixPaths;
    }

    public List<PartialPath> getSuffixPaths() {
        return this.suffixList;
    }

    public boolean isLastQuery() {
        return this.lastQuery;
    }
}

