/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePartitionPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UpdatePlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.OperateFilePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.TracingPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowTimeseriesDataSet;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.AuthUtils;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.EmptyDataSet;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanExecutor
implements IPlanExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PlanExecutor.class);
    protected IQueryRouter queryRouter = new QueryRouter();
    private IAuthorizer authorizer;

    public PlanExecutor() throws QueryProcessException {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException, MetadataException {
        if (queryPlan instanceof QueryPlan) {
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            return this.processAuthorQuery((AuthorPlan)queryPlan);
        }
        if (queryPlan instanceof ShowPlan) {
            return this.processShowQuery((ShowPlan)queryPlan, context);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    @Override
    public boolean processNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        switch (plan.getOperatorType()) {
            case DELETE: {
                this.delete((DeletePlan)plan);
                return true;
            }
            case UPDATE: {
                UpdatePlan update = (UpdatePlan)plan;
                for (Pair<Long, Long> timePair : update.getIntervals()) {
                    this.update(update.getPath(), (Long)timePair.left, (Long)timePair.right, update.getValue());
                }
                return true;
            }
            case INSERT: {
                this.insert((InsertRowPlan)plan);
                return true;
            }
            case BATCHINSERT: {
                this.insertTablet((InsertTabletPlan)plan);
                return true;
            }
            case CREATE_ROLE: 
            case DELETE_ROLE: 
            case CREATE_USER: 
            case REVOKE_USER_ROLE: 
            case REVOKE_ROLE_PRIVILEGE: 
            case REVOKE_USER_PRIVILEGE: 
            case GRANT_ROLE_PRIVILEGE: 
            case GRANT_USER_PRIVILEGE: 
            case GRANT_USER_ROLE: 
            case MODIFY_PASSWORD: 
            case DELETE_USER: {
                AuthorPlan author = (AuthorPlan)plan;
                return this.operateAuthor(author);
            }
            case GRANT_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), true);
            }
            case REVOKE_WATERMARK_EMBEDDING: {
                return this.operateWatermarkEmbedding(((DataAuthPlan)plan).getUsers(), false);
            }
            case DELETE_TIMESERIES: {
                return this.deleteTimeSeries((DeleteTimeSeriesPlan)plan);
            }
            case CREATE_TIMESERIES: {
                return this.createTimeSeries((CreateTimeSeriesPlan)plan);
            }
            case CREATE_MULTI_TIMESERIES: {
                return this.createMultiTimeSeries((CreateMultiTimeSeriesPlan)plan);
            }
            case ALTER_TIMESERIES: {
                return this.alterTimeSeries((AlterTimeSeriesPlan)plan);
            }
            case SET_STORAGE_GROUP: {
                return this.setStorageGroup((SetStorageGroupPlan)plan);
            }
            case DELETE_STORAGE_GROUP: {
                return this.deleteStorageGroups((DeleteStorageGroupPlan)plan);
            }
            case TTL: {
                this.operateTTL((SetTTLPlan)plan);
                return true;
            }
            case LOAD_CONFIGURATION: {
                this.loadConfiguration((LoadConfigurationPlan)plan);
                return true;
            }
            case LOAD_FILES: {
                this.operateLoadFiles((OperateFilePlan)plan);
                return true;
            }
            case REMOVE_FILE: {
                this.operateRemoveFile((OperateFilePlan)plan);
                return true;
            }
            case MOVE_FILE: {
                this.operateMoveFile((OperateFilePlan)plan);
                return true;
            }
            case FLUSH: {
                this.operateFlush((FlushPlan)plan);
                return true;
            }
            case MERGE: 
            case FULL_MERGE: {
                this.operateMerge((MergePlan)plan);
                return true;
            }
            case TRACING: {
                this.operateTracing((TracingPlan)plan);
                return true;
            }
            case CLEAR_CACHE: {
                this.operateClearCache();
                return true;
            }
            case DELETE_PARTITION: {
                DeletePartitionPlan p = (DeletePartitionPlan)plan;
                StorageGroupProcessor.TimePartitionFilter filter = (storageGroupName, partitionId) -> storageGroupName.equals(((DeletePartitionPlan)plan).getStorageGroupName().getFullPath()) && p.getPartitionId().contains(partitionId);
                StorageEngine.getInstance().removePartitions(((DeletePartitionPlan)plan).getStorageGroupName(), filter);
                return true;
            }
            case CREATE_SCHEMA_SNAPSHOT: {
                this.operateCreateSnapshot();
                return true;
            }
        }
        throw new UnsupportedOperationException(String.format("operation %s is not supported", new Object[]{plan.getOperatorType()}));
    }

    private void operateMerge(MergePlan plan) throws StorageEngineException {
        if (plan.getOperatorType() == Operator.OperatorType.FULL_MERGE) {
            StorageEngine.getInstance().mergeAll(true);
        } else {
            StorageEngine.getInstance().mergeAll(IoTDBDescriptor.getInstance().getConfig().isForceFullMerge());
        }
    }

    private void operateClearCache() {
        ChunkCache.getInstance().clear();
        ChunkMetadataCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
    }

    private void operateCreateSnapshot() {
        IoTDB.metaManager.createMTreeSnapshot();
    }

    private void operateTracing(TracingPlan plan) {
        IoTDBDescriptor.getInstance().getConfig().setEnablePerformanceTracing(plan.isTracingOn());
    }

    private void operateFlush(FlushPlan plan) throws StorageGroupNotSetException {
        List<PartialPath> noExistSg;
        if (plan.getPaths().isEmpty()) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        } else {
            this.flushSpecifiedStorageGroups(plan);
        }
        if (!plan.getPaths().isEmpty() && !(noExistSg = this.checkStorageGroupExist(plan.getPaths())).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            noExistSg.forEach(storageGroup -> sb.append(storageGroup.getFullPath()).append(","));
            throw new StorageGroupNotSetException(sb.subSequence(0, sb.length() - 1).toString());
        }
    }

    private void flushSpecifiedStorageGroups(FlushPlan plan) throws StorageGroupNotSetException {
        Map<PartialPath, List<Pair<Long, Boolean>>> storageGroupMap = plan.getStorageGroupPartitionIds();
        for (Map.Entry<PartialPath, List<Pair<Long, Boolean>>> entry : storageGroupMap.entrySet()) {
            PartialPath storageGroupName = entry.getKey();
            if (entry.getValue() == null) {
                if (plan.isSeq() == null) {
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, true, plan.isSync());
                    StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, false, plan.isSync());
                    continue;
                }
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, plan.isSeq(), plan.isSync());
                continue;
            }
            List<Pair<Long, Boolean>> partitionIdSequencePairs = entry.getValue();
            for (Pair<Long, Boolean> pair : partitionIdSequencePairs) {
                StorageEngine.getInstance().closeStorageGroupProcessor(storageGroupName, (Long)pair.left, (Boolean)pair.right, true);
            }
        }
    }

    protected QueryDataSet processDataQuery(QueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryFilterOptimizationException, QueryProcessException, IOException {
        AlignByDeviceDataSet queryDataSet;
        if (queryPlan instanceof AlignByDevicePlan) {
            queryDataSet = this.getAlignByDeviceDataSet((AlignByDevicePlan)queryPlan, context, this.queryRouter);
        } else {
            if (queryPlan.getPaths() == null || queryPlan.getPaths().isEmpty()) {
                return new EmptyDataSet();
            }
            if (queryPlan instanceof GroupByTimeFillPlan) {
                GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)queryPlan;
                queryDataSet = this.queryRouter.groupByFill(groupByFillPlan, context);
            } else if (queryPlan instanceof GroupByTimePlan) {
                GroupByTimePlan groupByTimePlan = (GroupByTimePlan)queryPlan;
                queryDataSet = this.queryRouter.groupBy(groupByTimePlan, context);
            } else if (queryPlan instanceof AggregationPlan) {
                AggregationPlan aggregationPlan = (AggregationPlan)queryPlan;
                queryDataSet = this.queryRouter.aggregate(aggregationPlan, context);
            } else if (queryPlan instanceof FillQueryPlan) {
                FillQueryPlan fillQueryPlan = (FillQueryPlan)queryPlan;
                queryDataSet = this.queryRouter.fill(fillQueryPlan, context);
            } else {
                queryDataSet = queryPlan instanceof LastQueryPlan ? this.queryRouter.lastQuery((LastQueryPlan)queryPlan, context) : this.queryRouter.rawDataQuery((RawDataQueryPlan)queryPlan, context);
            }
        }
        queryDataSet.setRowLimit(queryPlan.getRowLimit());
        queryDataSet.setRowOffset(queryPlan.getRowOffset());
        return queryDataSet;
    }

    protected AlignByDeviceDataSet getAlignByDeviceDataSet(AlignByDevicePlan plan, QueryContext context, IQueryRouter router) {
        return new AlignByDeviceDataSet(plan, context, router);
    }

    protected QueryDataSet processShowQuery(ShowPlan showPlan, QueryContext context) throws QueryProcessException, MetadataException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return this.processShowTTLQuery((ShowTTLPlan)showPlan);
            }
            case FLUSH_TASK_INFO: {
                return this.processShowFlushTaskInfo();
            }
            case VERSION: {
                return this.processShowVersion();
            }
            case TIMESERIES: {
                return this.processShowTimeseries((ShowTimeSeriesPlan)showPlan, context);
            }
            case STORAGE_GROUP: {
                return this.processShowStorageGroup((ShowStorageGroupPlan)showPlan);
            }
            case DEVICES: {
                return this.processShowDevices((ShowDevicesPlan)showPlan);
            }
            case CHILD_PATH: {
                return this.processShowChildPaths((ShowChildPathsPlan)showPlan);
            }
            case COUNT_TIMESERIES: {
                return this.processCountTimeSeries((CountPlan)showPlan);
            }
            case COUNT_NODE_TIMESERIES: {
                return this.processCountNodeTimeSeries((CountPlan)showPlan);
            }
            case COUNT_DEVICES: {
                return this.processCountDevices((CountPlan)showPlan);
            }
            case COUNT_STORAGE_GROUP: {
                return this.processCountStorageGroup((CountPlan)showPlan);
            }
            case COUNT_NODES: {
                return this.processCountNodes((CountPlan)showPlan);
            }
            case MERGE_STATUS: {
                return this.processShowMergeStatus();
            }
        }
        throw new QueryProcessException(String.format("Unrecognized show plan %s", showPlan));
    }

    private QueryDataSet processCountNodes(CountPlan countPlan) throws MetadataException {
        int num = this.getNodesNumInGivenLevel(countPlan.getPath(), countPlan.getLevel());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("count", false)), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private QueryDataSet processCountNodeTimeSeries(CountPlan countPlan) throws MetadataException {
        List<PartialPath> nodes = this.getNodesList(countPlan.getPath(), countPlan.getLevel());
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("column", false), new PartialPath("count", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        for (PartialPath columnPath : nodes) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(columnPath.getFullPath()));
            Field field1 = new Field(TSDataType.INT32);
            field1.setIntV(this.getPathsNum(columnPath));
            record.addField(field);
            record.addField(field1);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processCountDevices(CountPlan countPlan) throws MetadataException {
        int num = this.getDevicesNum(countPlan.getPath());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("devices", false)), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private QueryDataSet processCountStorageGroup(CountPlan countPlan) throws MetadataException {
        int num = this.getStorageGroupNum(countPlan.getPath());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("storage group", false)), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private int getDevicesNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevicesNum(path);
    }

    private int getStorageGroupNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getStorageGroupNum(path);
    }

    protected int getPathsNum(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesCount(path);
    }

    protected int getNodesNumInGivenLevel(PartialPath path, int level) throws MetadataException {
        return IoTDB.metaManager.getNodesCountInGivenLevel(path, level);
    }

    protected List<PartialPath> getPathsName(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPath(path);
    }

    protected List<PartialPath> getNodesList(PartialPath schemaPattern, int level) throws MetadataException {
        return IoTDB.metaManager.getNodesList(schemaPattern, level);
    }

    private QueryDataSet processCountTimeSeries(CountPlan countPlan) throws MetadataException {
        int num = this.getPathsNum(countPlan.getPath());
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.INT32));
        Field field = new Field(TSDataType.INT32);
        field.setIntV(num);
        RowRecord record = new RowRecord(0L);
        record.addField(field);
        singleDataSet.setRecord(record);
        return singleDataSet;
    }

    private QueryDataSet processShowDevices(ShowDevicesPlan showDevicesPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("devices", false)), Collections.singletonList(TSDataType.TEXT));
        Set<PartialPath> devices = this.getDevices(showDevicesPlan.getPath());
        for (PartialPath s : devices) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s.getFullPath()));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<PartialPath> getDevices(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getDevices(path);
    }

    private QueryDataSet processShowChildPaths(ShowChildPathsPlan showChildPathsPlan) throws MetadataException {
        Set<String> childPathsList = this.getPathNextChildren(showChildPathsPlan.getPath());
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("child paths", false)), Collections.singletonList(TSDataType.TEXT));
        for (String s : childPathsList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    protected Set<String> getPathNextChildren(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getChildNodePathInNextLevel(path);
    }

    protected List<PartialPath> getStorageGroupNames(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getStorageGroupPaths(path);
    }

    private QueryDataSet processShowStorageGroup(ShowStorageGroupPlan showStorageGroupPlan) throws MetadataException {
        ListDataSet listDataSet = new ListDataSet(Collections.singletonList(new PartialPath("storage group", false)), Collections.singletonList(TSDataType.TEXT));
        List<PartialPath> storageGroupList = this.getStorageGroupNames(showStorageGroupPlan.getPath());
        for (PartialPath s : storageGroupList) {
            RowRecord record = new RowRecord(0L);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(s.getFullPath()));
            record.addField(field);
            listDataSet.putRecord(record);
        }
        return listDataSet;
    }

    private QueryDataSet processShowTimeseries(ShowTimeSeriesPlan showTimeSeriesPlan, QueryContext context) throws MetadataException {
        return new ShowTimeseriesDataSet(showTimeSeriesPlan, context);
    }

    protected List<StorageGroupMNode> getAllStorageGroupNodes() {
        return IoTDB.metaManager.getAllStorageGroupNodes();
    }

    private QueryDataSet processShowTTLQuery(ShowTTLPlan showTTLPlan) {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("storage group", false), new PartialPath("ttl", false)), Arrays.asList(TSDataType.TEXT, TSDataType.INT64));
        List<PartialPath> selectedSgs = showTTLPlan.getStorageGroups();
        List<StorageGroupMNode> storageGroups = this.getAllStorageGroupNodes();
        int timestamp = 0;
        for (StorageGroupMNode mNode : storageGroups) {
            Field ttl;
            PartialPath sgName = mNode.getPartialPath();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName)) continue;
            RowRecord rowRecord = new RowRecord((long)timestamp++);
            Field sg = new Field(TSDataType.TEXT);
            sg.setBinaryV(new Binary(sgName.getFullPath()));
            if (mNode.getDataTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(mNode.getDataTTL());
            } else {
                ttl = null;
            }
            rowRecord.addField(sg);
            rowRecord.addField(ttl);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    private QueryDataSet processShowVersion() {
        SingleDataSet singleDataSet = new SingleDataSet(Collections.singletonList(new PartialPath("        version", false)), Collections.singletonList(TSDataType.TEXT));
        Field field = new Field(TSDataType.TEXT);
        field.setBinaryV(new Binary(IoTDBConstant.VERSION));
        RowRecord rowRecord = new RowRecord(0L);
        rowRecord.addField(field);
        singleDataSet.setRecord(rowRecord);
        return singleDataSet;
    }

    private QueryDataSet processShowFlushTaskInfo() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("                             item", false), new PartialPath("value", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT));
        int timestamp = 0;
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "total number of flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getTotalTasks()));
        this.addRowRecordForShowQuery(listDataSet, timestamp++, "number of working flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWorkingTasksNumber()));
        this.addRowRecordForShowQuery(listDataSet, timestamp, "number of waiting flush tasks", Integer.toString(FlushTaskPoolManager.getInstance().getWaitingTasksNumber()));
        return listDataSet;
    }

    private void addRowRecordForShowQuery(ListDataSet listDataSet, int timestamp, String item, String value) {
        RowRecord rowRecord = new RowRecord((long)timestamp);
        Field itemField = new Field(TSDataType.TEXT);
        itemField.setBinaryV(new Binary(item));
        Field valueField = new Field(TSDataType.TEXT);
        valueField.setBinaryV(new Binary(value));
        rowRecord.addField(itemField);
        rowRecord.addField(valueField);
        listDataSet.putRecord(rowRecord);
    }

    @Override
    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        for (PartialPath path : deletePlan.getPaths()) {
            this.delete(path, deletePlan.getDeleteStartTime(), deletePlan.getDeleteEndTime(), deletePlan.getIndex());
        }
    }

    private void operateLoadFiles(OperateFilePlan plan) throws QueryProcessException {
        File file = plan.getFile();
        if (!file.exists()) {
            throw new QueryProcessException(String.format("File path %s doesn't exists.", file.getPath()));
        }
        if (file.isDirectory()) {
            this.recursionFileDir(file, plan);
        } else {
            this.loadFile(file, plan);
        }
    }

    private void recursionFileDir(File curFile, OperateFilePlan plan) throws QueryProcessException {
        File[] files;
        for (File file : files = curFile.listFiles()) {
            if (file.isDirectory()) {
                this.recursionFileDir(file, plan);
                continue;
            }
            this.loadFile(file, plan);
        }
    }

    private void loadFile(File file, OperateFilePlan plan) throws QueryProcessException {
        if (!file.getName().endsWith(".tsfile")) {
            return;
        }
        TsFileResource tsFileResource = new TsFileResource(file);
        long fileVersion = Long.parseLong(tsFileResource.getTsFile().getName().split("-")[1]);
        tsFileResource.setHistoricalVersions(Collections.singleton(fileVersion));
        tsFileResource.setClosed(true);
        try {
            RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(file);
            if (restorableTsFileIOWriter.hasCrashed()) {
                restorableTsFileIOWriter.close();
                throw new QueryProcessException(String.format("Cannot load file %s because the file has crashed.", file.getAbsolutePath()));
            }
            HashMap<Path, MeasurementSchema> schemaMap = new HashMap<Path, MeasurementSchema>();
            ArrayList versionInfo = new ArrayList();
            ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                reader.selfCheck(schemaMap, chunkGroupMetadataList, versionInfo, false);
            }
            FileLoaderUtils.checkTsFileResource(tsFileResource);
            if (UpgradeUtils.isNeedUpgrade(tsFileResource)) {
                throw new QueryProcessException(String.format("Cannot load file %s because the file's version is old which needs to be upgraded.", file.getAbsolutePath()));
            }
            if (plan.isAutoCreateSchema()) {
                this.createSchemaAutomatically(chunkGroupMetadataList, schemaMap, plan.getSgLevel());
            }
            StorageEngine.getInstance().loadNewTsFile(tsFileResource);
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Cannot load file %s because %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    private void createSchemaAutomatically(List<ChunkGroupMetadata> chunkGroupMetadataList, Map<Path, MeasurementSchema> knownSchemas, int sgLevel) throws QueryProcessException, MetadataException {
        if (chunkGroupMetadataList.isEmpty()) {
            return;
        }
        HashSet<PartialPath> registeredSeries = new HashSet<PartialPath>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            String device = chunkGroupMetadata.getDevice();
            MNode node = null;
            node = IoTDB.metaManager.getDeviceNodeWithAutoCreate(new PartialPath(device), true, sgLevel);
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                PartialPath series = new PartialPath(chunkGroupMetadata.getDevice() + "." + chunkMetadata.getMeasurementUid());
                if (registeredSeries.contains(series)) continue;
                registeredSeries.add(series);
                MeasurementSchema schema = knownSchemas.get(new Path(series.getDevice(), series.getMeasurement()));
                if (schema == null) {
                    throw new MetadataException(String.format("Can not get the schema of measurement [%s]", chunkMetadata.getMeasurementUid()));
                }
                if (!node.hasChild(chunkMetadata.getMeasurementUid())) {
                    IoTDB.metaManager.createTimeseries(series, schema.getType(), schema.getEncodingType(), schema.getCompressor(), Collections.emptyMap());
                    continue;
                }
                if (node.getChild(chunkMetadata.getMeasurementUid()) instanceof MeasurementMNode) continue;
                throw new QueryProcessException(String.format("Current Path is not leaf node. %s", series));
            }
        }
    }

    private void operateRemoveFile(OperateFilePlan plan) throws QueryProcessException {
        try {
            if (!StorageEngine.getInstance().deleteTsfile(plan.getFile())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot remove file because %s", e.getMessage()));
        }
    }

    private void operateMoveFile(OperateFilePlan plan) throws QueryProcessException {
        if (!plan.getTargetDir().exists() || !plan.getTargetDir().isDirectory()) {
            throw new QueryProcessException(String.format("Target dir %s is invalid.", plan.getTargetDir().getPath()));
        }
        try {
            if (!StorageEngine.getInstance().moveTsfile(plan.getFile(), plan.getTargetDir())) {
                throw new QueryProcessException(String.format("File %s doesn't exist.", plan.getFile().getName()));
            }
        }
        catch (StorageEngineException | IllegalPathException e) {
            throw new QueryProcessException(String.format("Cannot move file %s to target directory %s because %s", plan.getFile().getPath(), plan.getTargetDir().getPath(), e.getMessage()));
        }
    }

    private void operateTTL(SetTTLPlan plan) throws QueryProcessException {
        try {
            IoTDB.metaManager.setTTL(plan.getStorageGroup(), plan.getDataTTL());
            StorageEngine.getInstance().setTTL(plan.getStorageGroup(), plan.getDataTTL());
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public void update(PartialPath path, long startTime, long endTime, String value) {
        throw new UnsupportedOperationException("update is not supported now");
    }

    @Override
    public void delete(PartialPath path, long startTime, long endTime, long planIndex) throws QueryProcessException {
        try {
            StorageEngine.getInstance().delete(path, startTime, endTime, planIndex);
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException(e);
        }
    }

    private MNode getSeriesSchemas(InsertPlan insertPlan) throws MetadataException {
        return IoTDB.metaManager.getSeriesSchemasAndReadLockDevice(insertPlan);
    }

    @Override
    public void insert(InsertRowPlan insertRowPlan) throws QueryProcessException {
        try {
            if (insertRowPlan.getMeasurements() == null) {
                throw new QueryProcessException("The measurements of InsertRowPlan is null, deviceId:" + insertRowPlan.getDeviceId() + ", time:" + insertRowPlan.getTime());
            }
            if (insertRowPlan.getValues().length == 0) {
                throw new QueryProcessException("The size of values in this InsertRowPlan is 0, deviceId:" + insertRowPlan.getDeviceId() + ", time:" + insertRowPlan.getTime());
            }
            insertRowPlan.setMeasurementMNodes(new MeasurementMNode[insertRowPlan.getMeasurements().length]);
            this.getSeriesSchemas(insertRowPlan);
            insertRowPlan.transferType();
            StorageEngine.getInstance().insert(insertRowPlan);
            if (insertRowPlan.getFailedMeasurements() != null) {
                List<String> failedPaths = insertRowPlan.getFailedMeasurements();
                List<Exception> exceptions = insertRowPlan.getFailedExceptions();
                boolean isPathNotExistException = true;
                Iterator<Exception> iterator = exceptions.iterator();
                while (iterator.hasNext()) {
                    Exception e;
                    Throwable curException = e = iterator.next();
                    while (curException.getCause() != null) {
                        curException = curException.getCause();
                    }
                    if (curException instanceof PathNotExistException) continue;
                    isPathNotExistException = false;
                    break;
                }
                if (isPathNotExistException) {
                    throw new PathNotExistException(failedPaths);
                }
                throw new StorageEngineException("failed to insert points " + insertRowPlan.getFailedMeasurements());
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    @Override
    public void insertTablet(InsertTabletPlan insertTabletPlan) throws QueryProcessException {
        try {
            insertTabletPlan.setMeasurementMNodes(new MeasurementMNode[insertTabletPlan.getMeasurements().length]);
            this.getSeriesSchemas(insertTabletPlan);
            StorageEngine.getInstance().insertTablet(insertTabletPlan);
            if (insertTabletPlan.getFailedMeasurements() != null) {
                throw new StorageEngineException("failed to insert measurements " + insertTabletPlan.getFailedMeasurements());
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
    }

    private boolean operateAuthor(AuthorPlan author) throws QueryProcessException {
        AuthorOperator.AuthorType authorType = author.getAuthorType();
        String userName = author.getUserName();
        String roleName = author.getRoleName();
        String password = author.getPassword();
        String newPassword = author.getNewPassword();
        Set<Integer> permissions = author.getPermissions();
        PartialPath nodeName = author.getNodeName();
        try {
            switch (authorType) {
                case UPDATE_USER: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CREATE_USER: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CREATE_ROLE: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DROP_USER: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DROP_ROLE: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GRANT_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_USER: {
                    for (int i : permissions) {
                        this.authorizer.grantPrivilegeToUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case GRANT_ROLE_TO_USER: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case REVOKE_USER: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromUser(userName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE: {
                    for (int i : permissions) {
                        this.authorizer.revokePrivilegeFromRole(roleName, nodeName.getFullPath(), i);
                    }
                    break;
                }
                case REVOKE_ROLE_FROM_USER: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean operateWatermarkEmbedding(List<String> users, boolean useWatermark) throws QueryProcessException {
        try {
            for (String user : users) {
                this.authorizer.setUserUseWaterMark(user, useWatermark);
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return true;
    }

    private boolean createTimeSeries(CreateTimeSeriesPlan createTimeSeriesPlan) throws QueryProcessException {
        try {
            IoTDB.metaManager.createTimeseries(createTimeSeriesPlan);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean createMultiTimeSeries(CreateMultiTimeSeriesPlan multiPlan) {
        HashMap<Integer, Exception> results = new HashMap<Integer, Exception>(multiPlan.getPaths().size());
        for (int i = 0; i < multiPlan.getPaths().size(); ++i) {
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(multiPlan.getPaths().get(i), multiPlan.getDataTypes().get(i), multiPlan.getEncodings().get(i), multiPlan.getCompressors().get(i), multiPlan.getProps() == null ? null : multiPlan.getProps().get(i), multiPlan.getTags() == null ? null : multiPlan.getTags().get(i), multiPlan.getAttributes() == null ? null : multiPlan.getAttributes().get(i), multiPlan.getAlias() == null ? null : multiPlan.getAlias().get(i));
            try {
                this.createTimeSeries(plan);
                continue;
            }
            catch (QueryProcessException e) {
                results.put(multiPlan.getIndexes().get(i), e);
                logger.debug("meet error while processing create timeseries. ", (Throwable)e);
            }
        }
        multiPlan.setResults(results);
        return true;
    }

    protected boolean deleteTimeSeries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws QueryProcessException {
        List<PartialPath> deletePathList = deleteTimeSeriesPlan.getPaths();
        try {
            LinkedList<String> failedNames = new LinkedList<String>();
            for (PartialPath path : deletePathList) {
                StorageEngine.getInstance().deleteTimeseries(path, deleteTimeSeriesPlan.getIndex());
                String failedTimeseries = IoTDB.metaManager.deleteTimeseries(path);
                if (failedTimeseries.isEmpty()) continue;
                failedNames.add(failedTimeseries);
            }
            if (!failedNames.isEmpty()) {
                throw new DeleteFailedException(String.join((CharSequence)",", failedNames));
            }
        }
        catch (StorageEngineException | MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    private boolean alterTimeSeries(AlterTimeSeriesPlan alterTimeSeriesPlan) throws QueryProcessException {
        PartialPath path = alterTimeSeriesPlan.getPath();
        Map<String, String> alterMap = alterTimeSeriesPlan.getAlterMap();
        try {
            switch (alterTimeSeriesPlan.getAlterType()) {
                case RENAME: {
                    String beforeName = alterMap.keySet().iterator().next();
                    String currentName = alterMap.get(beforeName);
                    IoTDB.metaManager.renameTagOrAttributeKey(beforeName, currentName, path);
                    break;
                }
                case SET: {
                    IoTDB.metaManager.setTagsOrAttributesValue(alterMap, path);
                    break;
                }
                case DROP: {
                    IoTDB.metaManager.dropTagsOrAttributes(alterMap.keySet(), path);
                    break;
                }
                case ADD_TAGS: {
                    IoTDB.metaManager.addTags(alterMap, path);
                    break;
                }
                case ADD_ATTRIBUTES: {
                    IoTDB.metaManager.addAttributes(alterMap, path);
                    break;
                }
                case UPSERT: {
                    IoTDB.metaManager.upsertTagsAndAttributes(alterTimeSeriesPlan.getAlias(), alterTimeSeriesPlan.getTagsMap(), alterTimeSeriesPlan.getAttributesMap(), path);
                }
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        catch (IOException e) {
            throw new QueryProcessException(String.format("Something went wrong while read/write the [%s]'s tag/attribute info.", path.getFullPath()));
        }
        return true;
    }

    public boolean setStorageGroup(SetStorageGroupPlan setStorageGroupPlan) throws QueryProcessException {
        PartialPath path = setStorageGroupPlan.getPath();
        try {
            IoTDB.metaManager.setStorageGroup(path);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected boolean deleteStorageGroups(DeleteStorageGroupPlan deleteStorageGroupPlan) throws QueryProcessException {
        ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
        try {
            for (PartialPath storageGroupPath : deleteStorageGroupPlan.getPaths()) {
                List<PartialPath> allRelatedStorageGroupPath = IoTDB.metaManager.getStorageGroupPaths(storageGroupPath);
                if (allRelatedStorageGroupPath.isEmpty()) {
                    throw new PathNotExistException(storageGroupPath.getFullPath());
                }
                for (PartialPath path : allRelatedStorageGroupPath) {
                    StorageEngine.getInstance().deleteStorageGroup(path);
                    deletePathList.add(path);
                }
            }
            IoTDB.metaManager.deleteStorageGroups(deletePathList);
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
        return true;
    }

    protected QueryDataSet processAuthorQuery(AuthorPlan plan) throws QueryProcessException {
        ListDataSet dataSet;
        AuthorOperator.AuthorType authorType = plan.getAuthorType();
        String userName = plan.getUserName();
        String roleName = plan.getRoleName();
        PartialPath path = plan.getNodeName();
        try {
            switch (authorType) {
                case LIST_ROLE: {
                    dataSet = this.executeListRole(plan);
                    break;
                }
                case LIST_USER: {
                    dataSet = this.executeListUser(plan);
                    break;
                }
                case LIST_ROLE_USERS: {
                    dataSet = this.executeListRoleUsers(roleName);
                    break;
                }
                case LIST_USER_ROLES: {
                    dataSet = this.executeListUserRoles(userName);
                    break;
                }
                case LIST_ROLE_PRIVILEGE: {
                    dataSet = this.executeListRolePrivileges(roleName, path);
                    break;
                }
                case LIST_USER_PRIVILEGE: {
                    dataSet = this.executeListUserPrivileges(userName, path);
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported operation " + (Object)((Object)authorType));
                }
            }
        }
        catch (AuthException e) {
            throw new QueryProcessException(e.getMessage());
        }
        return dataSet;
    }

    private ListDataSet executeListRole(AuthorPlan plan) throws AuthException {
        int index = 0;
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("role", false));
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        boolean hasListRolePrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.emptyList(), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListRolePrivilege) {
            return dataSet;
        }
        List<String> roleList = this.authorizer.listAllRoles();
        for (String role : roleList) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(role));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUser(AuthorPlan plan) throws AuthException {
        int index = 0;
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("user", false));
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        boolean hasListUserPrivilege = AuthorityChecker.check(plan.getLoginUserName(), Collections.singletonList(plan.getNodeName()), plan.getOperatorType(), plan.getLoginUserName());
        if (!hasListUserPrivilege) {
            return dataSet;
        }
        List<String> userList = this.authorizer.listAllUsers();
        for (String user : userList) {
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(user));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListRoleUsers(String roleName) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role == null) {
            throw new AuthException("No such role : " + roleName);
        }
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("user", false));
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        List<String> userList = this.authorizer.listAllUsers();
        int index = 0;
        for (String userN : userList) {
            User userObj = this.authorizer.getUser(userN);
            if (userObj == null || !userObj.hasRole(roleName)) continue;
            RowRecord record = new RowRecord((long)index++);
            Field field = new Field(TSDataType.TEXT);
            field.setBinaryV(new Binary(userN));
            record.addField(field);
            dataSet.putRecord(record);
        }
        return dataSet;
    }

    private ListDataSet executeListUserRoles(String userName) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user != null) {
            ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new PartialPath("role", false));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (String roleN : user.getRoleList()) {
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(roleN));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such user : " + userName);
    }

    private ListDataSet executeListRolePrivileges(String roleName, PartialPath path) throws AuthException {
        Role role = this.authorizer.getRole(roleName);
        if (role != null) {
            ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
            ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
            headerList.add(new PartialPath("privilege", false));
            typeList.add(TSDataType.TEXT);
            ListDataSet dataSet = new ListDataSet(headerList, typeList);
            int index = 0;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field field = new Field(TSDataType.TEXT);
                field.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(field);
                dataSet.putRecord(record);
            }
            return dataSet;
        }
        throw new AuthException("No such role : " + roleName);
    }

    private ListDataSet executeListUserPrivileges(String userName, PartialPath path) throws AuthException {
        User user = this.authorizer.getUser(userName);
        if (user == null) {
            throw new AuthException("No such user : " + userName);
        }
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("role", false));
        headerList.add(new PartialPath("privilege", false));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        int index = 0;
        for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
            if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
            RowRecord record = new RowRecord((long)index++);
            Field roleF = new Field(TSDataType.TEXT);
            roleF.setBinaryV(new Binary(""));
            record.addField(roleF);
            Field privilegeF = new Field(TSDataType.TEXT);
            privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
            record.addField(privilegeF);
            dataSet.putRecord(record);
        }
        for (String roleN : user.getRoleList()) {
            Role role = this.authorizer.getRole(roleN);
            if (role == null) continue;
            for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                if (path != null && !AuthUtils.pathBelongsTo(path.getFullPath(), pathPrivilege.getPath())) continue;
                RowRecord record = new RowRecord((long)index++);
                Field roleF = new Field(TSDataType.TEXT);
                roleF.setBinaryV(new Binary(roleN));
                record.addField(roleF);
                Field privilegeF = new Field(TSDataType.TEXT);
                privilegeF.setBinaryV(new Binary(pathPrivilege.toString()));
                record.addField(privilegeF);
                dataSet.putRecord(record);
            }
        }
        return dataSet;
    }

    protected String deleteTimeSeries(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.deleteTimeseries(path);
    }

    protected void loadConfiguration(LoadConfigurationPlan plan) throws QueryProcessException {
        IoTDBDescriptor.getInstance().loadHotModifiedProps();
    }

    private QueryDataSet processShowMergeStatus() {
        Map<String, List<MergeManager.TaskStatus>>[] taskStatus;
        ArrayList<PartialPath> headerList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> typeList = new ArrayList<TSDataType>();
        headerList.add(new PartialPath("storage group", false));
        headerList.add(new PartialPath("task name", false));
        headerList.add(new PartialPath("created time", false));
        headerList.add(new PartialPath("progress", false));
        headerList.add(new PartialPath("cancelled", false));
        headerList.add(new PartialPath("done", false));
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.TEXT);
        typeList.add(TSDataType.BOOLEAN);
        typeList.add(TSDataType.BOOLEAN);
        ListDataSet dataSet = new ListDataSet(headerList, typeList);
        for (Map<String, List<MergeManager.TaskStatus>> statusMap : taskStatus = MergeManager.getINSTANCE().collectTaskStatus()) {
            for (Map.Entry<String, List<MergeManager.TaskStatus>> stringListEntry : statusMap.entrySet()) {
                for (MergeManager.TaskStatus status : stringListEntry.getValue()) {
                    dataSet.putRecord(this.toRowRecord(status, stringListEntry.getKey()));
                }
            }
        }
        return dataSet;
    }

    public RowRecord toRowRecord(MergeManager.TaskStatus status, String storageGroup) {
        RowRecord record = new RowRecord(0L);
        record.addField((Object)new Binary(storageGroup), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getTaskName()), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getCreatedTime()), TSDataType.TEXT);
        record.addField((Object)new Binary(status.getProgress()), TSDataType.TEXT);
        record.addField((Object)status.isCancelled(), TSDataType.BOOLEAN);
        record.addField((Object)status.isDone(), TSDataType.BOOLEAN);
        return record;
    }

    List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (IoTDB.metaManager.isStorageGroup(storageGroup)) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }
}

