/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor;

import java.io.File;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.monitor.collector.FileSize;

public class MonitorConstants {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final String DATA_TYPE_INT64 = "INT64";
    static final String STAT_STORAGE_GROUP_PREFIX = "root.stats";
    private static final String[] STAT_STORAGE_GROUP_PREFIX_ARRAY = new String[]{"root", "stats"};
    static final String FILENODE_PROCESSOR_CONST = "FILENODE_PROCESSOR_CONST";
    private static final String FILENODE_MANAGER_CONST = "FILENODE_MANAGER_CONST";
    static final String FILE_SIZE_CONST = "FILE_SIZE_CONST";
    public static final String MONITOR_PATH_SEPARATOR = ".";
    private static final String FILE_SIZE = "file_size";
    public static final String FILE_SIZE_STORAGE_GROUP_NAME = "root.stats.file_size";
    private static final String FILE_NODE_MANAGER_PATH = "write.global";
    public static final String FILE_NODE_PATH = "write";
    static final String STAT_STORAGE_DELTA_NAME = "root.stats.write.global";

    static HashMap<String, AtomicLong> initValues(String constantsType) {
        HashMap hashMap = new HashMap();
        switch (constantsType) {
            case "FILENODE_PROCESSOR_CONST": {
                for (FileNodeProcessorStatConstants statConstant : FileNodeProcessorStatConstants.values()) {
                    hashMap.put(statConstant.name(), new AtomicLong(0L));
                }
                break;
            }
            case "FILENODE_MANAGER_CONST": {
                hashMap = (HashMap)FileSize.getInstance().getStatParamsHashMap();
                break;
            }
            case "FILE_SIZE_CONST": {
                for (FileSizeConstants kinds : FileSizeConstants.values()) {
                    hashMap.put(kinds.name(), new AtomicLong(0L));
                }
                break;
            }
        }
        return hashMap;
    }

    public static String[] getStatStorageGroupPrefixArray() {
        return STAT_STORAGE_GROUP_PREFIX_ARRAY;
    }

    static /* synthetic */ IoTDBConfig access$000() {
        return config;
    }

    public static enum FileSizeConstants {
        WAL(new File(MonitorConstants.access$000().getWalDir()).getAbsolutePath()),
        SYS(new File(MonitorConstants.access$000().getSystemDir()).getAbsolutePath());

        private String path;

        public String getPath() {
            return this.path;
        }

        private FileSizeConstants(String path) {
            this.path = path;
        }
    }

    public static enum OsStatConstants {
        NETWORK_REC,
        NETWORK_SEND,
        CPU_USAGE,
        MEM_USAGE,
        IOTDB_MEM_SIZE,
        DISK_USAGE,
        DISK_READ_SPEED,
        DISK_WRITE_SPEED,
        DISK_TPS;

    }

    public static enum FileNodeProcessorStatConstants {
        TOTAL_REQ_SUCCESS,
        TOTAL_REQ_FAIL,
        TOTAL_POINTS_SUCCESS,
        TOTAL_POINTS_FAIL;

    }

    public static enum FileNodeManagerStatConstants {
        TOTAL_POINTS,
        TOTAL_REQ_SUCCESS,
        TOTAL_REQ_FAIL,
        TOTAL_POINTS_SUCCESS,
        TOTAL_POINTS_FAIL;

    }
}

