/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.querycontext;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.reader.chunk.MemChunkLoader;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ReadOnlyMemChunk {
    private String measurementUid;
    private TSDataType dataType;
    private TSEncoding encoding;
    private long version;
    private int floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
    private ChunkMetadata cachedMetaData;
    private TVList chunkData;
    private IPointReader chunkPointReader;

    public ReadOnlyMemChunk(String measurementUid, TSDataType dataType, TSEncoding encoding, TVList tvList, Map<String, String> props, long version) throws IOException, QueryProcessException {
        this.measurementUid = measurementUid;
        this.dataType = dataType;
        this.encoding = encoding;
        this.version = version;
        if (props != null && props.containsKey("max_point_number")) {
            this.floatPrecision = Integer.parseInt(props.get("max_point_number"));
        }
        tvList.sort();
        this.chunkData = tvList;
        this.chunkPointReader = tvList.getIterator(this.floatPrecision, encoding);
        this.initChunkMeta();
    }

    private void initChunkMeta() throws IOException, QueryProcessException {
        Statistics statsByType = Statistics.getStatsByType((TSDataType)this.dataType);
        ChunkMetadata metaData = new ChunkMetadata(this.measurementUid, this.dataType, 0L, statsByType);
        if (!this.isEmpty()) {
            IPointReader iterator = this.chunkData.getIterator(this.floatPrecision, this.encoding);
            block8: while (iterator.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                switch (this.dataType) {
                    case BOOLEAN: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getBoolean());
                        continue block8;
                    }
                    case TEXT: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getBinary());
                        continue block8;
                    }
                    case FLOAT: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getFloat());
                        continue block8;
                    }
                    case INT32: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getInt());
                        continue block8;
                    }
                    case INT64: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getLong());
                        continue block8;
                    }
                    case DOUBLE: {
                        statsByType.update(timeValuePair.getTimestamp(), timeValuePair.getValue().getDouble());
                        continue block8;
                    }
                }
                throw new QueryProcessException("Unsupported data type:" + this.dataType);
            }
        }
        statsByType.setEmpty(this.isEmpty());
        metaData.setChunkLoader((IChunkLoader)new MemChunkLoader(this));
        metaData.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = metaData;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean isEmpty() throws IOException {
        return !this.chunkPointReader.hasNextTimeValuePair();
    }

    public ChunkMetadata getChunkMetaData() {
        return this.cachedMetaData;
    }

    public IPointReader getPointReader() {
        this.chunkPointReader = this.chunkData.getIterator(this.floatPrecision, this.encoding);
        return this.chunkPointReader;
    }

    public long getVersion() {
        return this.version;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }
}

