/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.querycontext;

import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;

public class QueryDataSource {
    private PartialPath seriesPath;
    private List<TsFileResource> seqResources;
    private List<TsFileResource> unseqResources;
    private long dataTTL = Long.MAX_VALUE;

    public QueryDataSource(PartialPath seriesPath, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        this.seriesPath = seriesPath;
        this.seqResources = seqResources;
        this.unseqResources = unseqResources;
    }

    public PartialPath getSeriesPath() {
        return this.seriesPath;
    }

    public List<TsFileResource> getSeqResources() {
        return this.seqResources;
    }

    public List<TsFileResource> getUnseqResources() {
        return this.unseqResources;
    }

    public long getDataTTL() {
        return this.dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    public Filter updateFilterUsingTTL(Filter filter) {
        if (this.dataTTL != Long.MAX_VALUE) {
            filter = filter != null ? new AndFilter(filter, (Filter)TimeFilter.gtEq((long)(System.currentTimeMillis() - this.dataTTL))) : TimeFilter.gtEq((long)(System.currentTimeMillis() - this.dataTTL));
        }
        return filter;
    }
}

