/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.io.LocalTextModificationAccessor;
import org.apache.iotdb.db.engine.modification.io.ModificationReader;
import org.apache.iotdb.db.engine.modification.io.ModificationWriter;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ModificationFile.class);
    public static final String FILE_SUFFIX = ".mods";
    private List<Modification> modifications;
    private ModificationWriter writer;
    private ModificationReader reader;
    private String filePath;
    private Random random = new Random();

    public ModificationFile(String filePath) {
        LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(filePath);
        this.writer = accessor;
        this.reader = accessor;
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            this.modifications = (List)this.reader.read();
        }
    }

    private void checkInit() {
        if (this.modifications == null) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            this.writer.close();
            this.modifications = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            if (!this.modifications.isEmpty()) {
                this.writer.abort();
                this.modifications.remove(this.modifications.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Modification mod) throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            this.checkInit();
            this.writer.write(mod);
            this.modifications.add(mod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModifications() {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            this.checkInit();
            return new ArrayList<Modification>(this.modifications);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void remove() throws IOException {
        this.close();
        FSFactoryProducer.getFSFactory().getFile(this.filePath).delete();
    }

    public boolean exists() {
        return new File(this.filePath).exists();
    }

    public ModificationFile createHardlink() {
        if (!this.exists()) {
            return null;
        }
        while (true) {
            String hardlinkSuffix = "." + System.currentTimeMillis() + "_" + this.random.nextLong();
            File hardlink = new File(this.filePath + hardlinkSuffix);
            try {
                Files.createLink(Paths.get(hardlink.getAbsolutePath(), new String[0]), Paths.get(this.filePath, new String[0]));
                return new ModificationFile(hardlink.getAbsolutePath());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            catch (IOException e) {
                logger.error("Cannot create hardlink for {}", (Object)this.filePath, (Object)e);
                return null;
            }
            break;
        }
    }
}

