/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.merge.manage.MergeContext;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeFileTask {
    private static final Logger logger = LoggerFactory.getLogger(MergeFileTask.class);
    private String taskName;
    private MergeContext context;
    private MergeLogger mergeLogger;
    private MergeResource resource;
    private List<TsFileResource> unmergedFiles;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private int currentMergeIndex;
    private String currMergeFile;

    MergeFileTask(String taskName, MergeContext context, MergeLogger mergeLogger, MergeResource resource, List<TsFileResource> unmergedSeqFiles) {
        this.taskName = taskName;
        this.context = context;
        this.mergeLogger = mergeLogger;
        this.resource = resource;
        this.unmergedFiles = unmergedSeqFiles;
    }

    void mergeFiles() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("{} starts to merge {} files", (Object)this.taskName, (Object)this.unmergedFiles.size());
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.unmergedFiles.size(); ++i) {
            TsFileResource seqFile = this.unmergedFiles.get(i);
            this.currentMergeIndex = i;
            this.currMergeFile = seqFile.getTsFilePath();
            int mergedChunkNum = this.context.getMergedChunkCnt().getOrDefault(seqFile, 0);
            int unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0);
            if (logger.isInfoEnabled()) {
                logger.info("{} moving unmerged data of {} to the merged file, {} merged chunks, {} unmerged chunks", new Object[]{this.taskName, seqFile.getTsFile().getName(), mergedChunkNum, unmergedChunkNum});
            }
            this.moveUnmergedToNew(seqFile);
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.logProgress();
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} has merged all files after {}ms", (Object)this.taskName, (Object)(System.currentTimeMillis() - startTime));
        }
        this.mergeLogger.logMergeEnd();
    }

    private void logProgress() {
        if (logger.isInfoEnabled()) {
            logger.debug("{} has merged {}, processed {}/{} files", new Object[]{this.taskName, this.currMergeFile, this.currentMergeIndex + 1, this.unmergedFiles.size()});
        }
    }

    public String getProgress() {
        return String.format("Merging %s, processed %d/%d files", this.currMergeFile, this.currentMergeIndex + 1, this.unmergedFiles.size());
    }

    private void updateHistoricalVersions(TsFileResource seqFile) {
        HashSet<Long> newHistoricalVersions = new HashSet<Long>(seqFile.getHistoricalVersions());
        for (TsFileResource unseqFiles : this.resource.getUnseqFiles()) {
            newHistoricalVersions.addAll(unseqFiles.getHistoricalVersions());
        }
        seqFile.setHistoricalVersions(newHistoricalVersions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUnmergedToNew(TsFileResource seqFile) throws IOException {
        Map<PartialPath, List<Long>> fileUnmergedChunkStartTimes = this.context.getUnmergedChunkStartTimes().get(seqFile);
        RestorableTsFileIOWriter fileWriter = this.resource.getMergeFileWriter(seqFile);
        this.mergeLogger.logFileMergeStart(fileWriter.getFile(), fileWriter.getFile().length());
        logger.debug("{} moving unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
        int unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0);
        if (unmergedChunkNum > 0) {
            for (Map.Entry<PartialPath, List<Long>> entry : fileUnmergedChunkStartTimes.entrySet()) {
                PartialPath path = entry.getKey();
                List<Long> chunkStartTimes = entry.getValue();
                if (chunkStartTimes.isEmpty()) continue;
                List<ChunkMetadata> chunkMetadataList = this.resource.queryChunkMetadata(path, seqFile);
                if (logger.isDebugEnabled()) {
                    logger.debug("{} find {} unmerged chunks", (Object)this.taskName, (Object)chunkMetadataList.size());
                }
                fileWriter.startChunkGroup(path.getDevice());
                long maxVersion = this.writeUnmergedChunks(chunkStartTimes, chunkMetadataList, this.resource.getFileReader(seqFile), fileWriter);
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                fileWriter.writeVersion(maxVersion + 1L);
                fileWriter.endChunkGroup();
            }
        }
        fileWriter.endFile();
        this.updateHistoricalVersions(seqFile);
        seqFile.serialize();
        this.mergeLogger.logFileMergeEnd();
        logger.debug("{} moved unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
        seqFile.writeLock();
        try {
            this.resource.removeFileReader(seqFile);
            ChunkMetadataCache.getInstance().remove(seqFile);
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            File newMergeFile = seqFile.getTsFile();
            newMergeFile.delete();
            this.fsFactory.moveFile(fileWriter.getFile(), newMergeFile);
            seqFile.setFile(newMergeFile);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (IoTDBDescriptor.getInstance().getConfig().isMetaDataCacheEnable()) {
                ChunkCache.getInstance().clear();
                ChunkMetadataCache.getInstance().clear();
                TimeSeriesMetadataCache.getInstance().clear();
                FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            }
            seqFile.writeUnlock();
        }
    }

    private long writeUnmergedChunks(List<Long> chunkStartTimes, List<ChunkMetadata> chunkMetadataList, TsFileSequenceReader reader, RestorableTsFileIOWriter fileWriter) throws IOException {
        long maxVersion = 0L;
        int chunkIdx = 0;
        for (Long startTime : chunkStartTimes) {
            while (chunkIdx < chunkMetadataList.size()) {
                ChunkMetadata metaData = chunkMetadataList.get(chunkIdx);
                if (metaData.getStartTime() == startTime.longValue()) {
                    Chunk chunk = reader.readMemChunk(metaData);
                    fileWriter.writeChunk(chunk, metaData);
                    maxVersion = metaData.getVersion() > maxVersion ? metaData.getVersion() : maxVersion;
                    this.context.incTotalPointWritten(metaData.getNumOfPoints());
                    break;
                }
                ++chunkIdx;
            }
            if (!Thread.interrupted()) continue;
            Thread.currentThread().interrupt();
            return maxVersion;
        }
        return maxVersion;
    }

    private File getNextMergeVersionFile(File seqFile) {
        String[] splits = seqFile.getName().replace(".tsfile", "").split("-");
        int mergeVersion = Integer.parseInt(splits[2]) + 1;
        return this.fsFactory.getFile(seqFile.getParentFile(), splits[0] + "-" + splits[1] + "-" + mergeVersion + ".tsfile");
    }
}

