/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public interface IMemTable {
    public Map<String, Map<String, IWritableMemChunk>> getMemTableMap();

    public void write(String var1, String var2, MeasurementSchema var3, long var4, Object var6);

    public void write(InsertTabletPlan var1, int var2, int var3);

    public long size();

    public long memSize();

    public void addTVListRamCost(long var1);

    public long getTVListsRamCost();

    public boolean reachTotalPointNumThreshold();

    public int getSeriesNumber();

    public long getTotalPointsNum();

    public void insert(InsertRowPlan var1);

    public void insertTablet(InsertTabletPlan var1, int var2, int var3) throws WriteProcessException;

    public ReadOnlyMemChunk query(String var1, String var2, TSDataType var3, TSEncoding var4, Map<String, String> var5, long var6) throws IOException, QueryProcessException, MetadataException;

    public void clear();

    public boolean isEmpty();

    public void delete(PartialPath var1, PartialPath var2, long var3, long var5);

    public void delete(Deletion var1);

    public IMemTable copy();

    public boolean isSignalMemTable();

    public long getVersion();

    public void setVersion(long var1);

    public void release();

    public boolean checkIfChunkDoesNotExist(String var1, String var2);

    public int getCurrentChunkPointNum(String var1, String var2);

    public void addTextDataSize(long var1);

    public long getMaxPlanIndex();

    public long getMinPlanIndex();
}

