/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.tsfile.common.cache.Accountable;

public abstract class LRULinkedHashMap<K extends Accountable, V> {
    private static final float LOAD_FACTOR_MAP = 0.75f;
    private static final int INITIAL_CAPACITY = 128;
    private static final float RETAIN_PERCENT = 0.9f;
    private static final int MAP_ENTRY_SIZE = 40;
    private final LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap(128, 0.75f);
    private final long maxMemory;
    private long usedMemory;
    private final long retainMemory;
    protected int count = 0;
    protected long averageSize = 0L;

    public LRULinkedHashMap(long maxMemory) {
        this.maxMemory = maxMemory;
        this.retainMemory = (long)((float)maxMemory * 0.9f);
    }

    public V put(K key, V value) {
        long size = this.calEntrySize(key, value) + 40L;
        key.setRamSize(size);
        this.usedMemory += size;
        V v = this.linkedHashMap.put(key, value);
        if (this.usedMemory > this.maxMemory) {
            Iterator<Map.Entry<K, V>> iterator = this.linkedHashMap.entrySet().iterator();
            while (this.usedMemory > this.retainMemory && iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                this.usedMemory -= ((Accountable)entry.getKey()).getRamSize();
                iterator.remove();
            }
        }
        return v;
    }

    public V get(K key) {
        return this.linkedHashMap.get(key);
    }

    public boolean containsKey(K key) {
        return this.linkedHashMap.containsKey(key);
    }

    public void clear() {
        this.linkedHashMap.clear();
        this.usedMemory = 0L;
        this.count = 0;
        this.averageSize = 0L;
    }

    public V remove(K key) {
        Object v = this.linkedHashMap.remove(key);
        if (v != null && key != null) {
            this.usedMemory -= key.getRamSize();
        }
        return v;
    }

    protected abstract long calEntrySize(K var1, V var2);

    public double getUsedMemoryProportion() {
        return (double)this.usedMemory * 1.0 / (double)this.maxMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getAverageSize() {
        return this.averageSize;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.linkedHashMap.entrySet();
    }

    public boolean isEmpty() {
        return this.linkedHashMap.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

