/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.iotdb.db.concurrent.IoTThreadFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThreadPoolFactory {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBThreadPoolFactory.class);

    private IoTDBThreadPoolFactory() {
    }

    public static ExecutorService newFixedThreadPool(int nthreads, String poolName) {
        logger.info("new fixed thread pool: {}, thread number: {}", (Object)poolName, (Object)nthreads);
        return Executors.newFixedThreadPool(nthreads, new IoTThreadFactory(poolName));
    }

    public static ExecutorService newFixedThreadPool(int nthreads, String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new fixed thread pool: {}, thread number: {}", (Object)poolName, (Object)nthreads);
        return Executors.newFixedThreadPool(nthreads, new IoTThreadFactory(poolName, handler));
    }

    public static ExecutorService newSingleThreadExecutor(String poolName) {
        logger.info("new single thread pool: {}", (Object)poolName);
        return Executors.newSingleThreadExecutor(new IoTThreadFactory(poolName));
    }

    public static ExecutorService newSingleThreadExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new single thread pool: {}", (Object)poolName);
        return Executors.newSingleThreadExecutor(new IoTThreadFactory(poolName, handler));
    }

    public static ExecutorService newCachedThreadPool(String poolName) {
        logger.info("new cached thread pool: {}", (Object)poolName);
        return Executors.newCachedThreadPool(new IoTThreadFactory(poolName));
    }

    public static ExecutorService newCachedThreadPool(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new cached thread pool: {}", (Object)poolName);
        return Executors.newCachedThreadPool(new IoTThreadFactory(poolName, handler));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        return Executors.newSingleThreadScheduledExecutor(new IoTThreadFactory(poolName));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        return Executors.newSingleThreadScheduledExecutor(new IoTThreadFactory(poolName, handler));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName) {
        return Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName, Thread.UncaughtExceptionHandler handler) {
        return Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName, handler));
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, (long)args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName));
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName, Thread.UncaughtExceptionHandler handler) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, (long)args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName, handler));
    }
}

