/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.role;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.auth.entity.PathPrivilege;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.role.IRoleAccessor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRoleAccessor
implements IRoleAccessor {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileRoleAccessor.class);
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private String roleDirPath;
    private ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileRoleAccessor(String roleDirPath) {
        this.roleDirPath = roleDirPath;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Role loadRole(String rolename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRole(Role role) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile" + TEMP_SUFFIX);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(roleProfile));){
            try {
                IOUtils.writeString(outputStream, role.getName(), STRING_ENCODING, this.encodingBufferLocal);
                role.getPrivilegeList().sort(PathPrivilege.REFERENCE_DESCENT_SORTER);
                int privilegeNum = role.getPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = role.getPrivilegeList().get(i);
                    IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
                }
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile");
        IOUtils.replaceFile(roleProfile, oldFile);
    }

    @Override
    public boolean deleteRole(String rolename) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile" + TEMP_SUFFIX);
        if (!roleProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (roleProfile.exists() && !roleProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete role file of %s", rolename));
        }
        return true;
    }

    @Override
    public List<String> listAllRoles() {
        File roleDir = SystemFileFactory.INSTANCE.getFile(this.roleDirPath);
        String[] names = roleDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.roleDirPath).mkdirs()) {
            logger.info("role info dir {} is created", (Object)this.roleDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.roleDirPath).exists()) {
            logger.error("role info dir {} can not be created", (Object)this.roleDirPath);
        }
    }
}

