<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

##  字符串处理

###  STRING_CONTAINS

####  函数简介

本函数判断字符串中是否存在子串 `s`

**函数名:** STRING_CONTAINS

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**参数:**
+ `s`: 待搜寻的字符串。

**输出序列:** 输出单个序列，类型为 BOOLEAN。

####  使用示例

```   sql
select s1, string_contains(s1, 's'='warn') from root.sg1.d4;
```

结果：

``` 
+-----------------------------+--------------+-------------------------------------------+
|                         Time|root.sg1.d4.s1|string_contains(root.sg1.d4.s1, "s"="warn")|
+-----------------------------+--------------+-------------------------------------------+
|1970-01-01T08:00:00.001+08:00|    warn:-8721|                                       true|
|1970-01-01T08:00:00.002+08:00|  error:-37229|                                      false|
|1970-01-01T08:00:00.003+08:00|     warn:1731|                                       true|
+-----------------------------+--------------+-------------------------------------------+
Total line number = 3
It costs 0.007s
```

###  STRING_MATCHES

####  函数简介

本函数判断字符串是否能够被正则表达式`regex`匹配。

**函数名:** STRING_MATCHES

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**参数:**
+ `regex`: Java 标准库风格的正则表达式。

**输出序列:** 输出单个序列，类型为 BOOLEAN。

####  使用示例

```   sql
select s1, string_matches(s1, 'regex'='[^\\s]+37229') from root.sg1.d4;
```

结果：

``` 
+-----------------------------+--------------+------------------------------------------------------+
|                         Time|root.sg1.d4.s1|string_matches(root.sg1.d4.s1, "regex"="[^\\s]+37229")|
+-----------------------------+--------------+------------------------------------------------------+
|1970-01-01T08:00:00.001+08:00|    warn:-8721|                                                 false|
|1970-01-01T08:00:00.002+08:00|  error:-37229|                                                  true|
|1970-01-01T08:00:00.003+08:00|     warn:1731|                                                 false|
+-----------------------------+--------------+------------------------------------------------------+
Total line number = 3
It costs 0.007s
```

###  Length

####  函数简介

本函数用于获取输入序列的长度。

**函数名:** LENGTH

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**输出序列:** 输出单个序列，类型为 INT32。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, length(s1) from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+----------------------+
|                         Time|root.sg1.d1.s1|length(root.sg1.d1.s1)|
+-----------------------------+--------------+----------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                     6|
|1970-01-01T08:00:00.002+08:00|      22test22|                     8|
+-----------------------------+--------------+----------------------+
```

###  Locate

####  函数简介

本函数用于获取`target`子串第一次出现在输入序列的位置，如果输入序列中不包含`target`则返回 -1 。

**函数名:** LOCATE

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**参数:**

+ `target`: 需要被定位的子串。
+ `reverse`: 指定是否需要倒序定位，默认值为`false`, 即从左至右定位。

**输出序列:** 输出单个序列，类型为INT32。

**提示:** 下标从 0 开始。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, locate(s1, "target"="1") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+------------------------------------+
|                         Time|root.sg1.d1.s1|locate(root.sg1.d1.s1, "target"="1")|
+-----------------------------+--------------+------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                                   0|
|1970-01-01T08:00:00.002+08:00|      22test22|                                  -1|
+-----------------------------+--------------+------------------------------------+
```

另一个用于查询的 SQL 语句:

```sql
select s1, locate(s1, "target"="1", "reverse"="true") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+------------------------------------------------------+
|                         Time|root.sg1.d1.s1|locate(root.sg1.d1.s1, "target"="1", "reverse"="true")|
+-----------------------------+--------------+------------------------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                                                     5|
|1970-01-01T08:00:00.002+08:00|      22test22|                                                    -1|
+-----------------------------+--------------+------------------------------------------------------+
```

###  StartsWith

####  函数简介

本函数用于判断输入序列是否有指定前缀。

**函数名:** STARTSWITH

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**参数:**
+ `target`: 需要匹配的前缀。

**输出序列:** 输出单个序列，类型为 BOOLEAN。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, startswith(s1, "target"="1") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+----------------------------------------+
|                         Time|root.sg1.d1.s1|startswith(root.sg1.d1.s1, "target"="1")|
+-----------------------------+--------------+----------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                                    true|
|1970-01-01T08:00:00.002+08:00|      22test22|                                   false|
+-----------------------------+--------------+----------------------------------------+
```

###  EndsWith

####  函数简介

本函数用于判断输入序列是否有指定后缀。

**函数名:** ENDSWITH

**输入序列:** 仅支持单个输入序列，类型为 TEXT。

**参数:**
+ `target`: 需要匹配的后缀。

**输出序列:** 输出单个序列，类型为 BOOLEAN。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, endswith(s1, "target"="1") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+--------------------------------------+
|                         Time|root.sg1.d1.s1|endswith(root.sg1.d1.s1, "target"="1")|
+-----------------------------+--------------+--------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                                  true|
|1970-01-01T08:00:00.002+08:00|      22test22|                                 false|
+-----------------------------+--------------+--------------------------------------+
```

###  Concat

####  函数简介

本函数用于拼接输入序列和`target`字串。

**函数名:** CONCAT

**输入序列:** 至少一个输入序列，类型为 TEXT。

**参数:**
+ `targets`: 一系列 K-V, key需要以`target`为前缀且不重复, value是待拼接的字符串。
+ `series_behind`: 指定拼接时时间序列是否在后面，默认为`false`。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:**
+ 如果输入序列是NULL, 跳过该序列的拼接。
+ 函数只能将输入序列和`targets`区分开各自拼接。`concat(s1, "target1"="IoT", s2, "target2"="DB")`和
  `concat(s1, s2, "target1"="IoT", "target2"="DB")`得到的结果是一样的。

####  使用示例

输入序列:

```
+-----------------------------+--------------+--------------+
|                         Time|root.sg1.d1.s1|root.sg1.d1.s2|
+-----------------------------+--------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|          null|
|1970-01-01T08:00:00.002+08:00|      22test22|      2222test|
+-----------------------------+--------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, s2, concat(s1, s2, "target1"="IoT", "target2"="DB") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------+
|                         Time|root.sg1.d1.s1|root.sg1.d1.s2|concat(root.sg1.d1.s1, root.sg1.d1.s2, "target1"="IoT", "target2"="DB")|
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|          null|                                                            1test1IoTDB|
|1970-01-01T08:00:00.002+08:00|      22test22|      2222test|                                                  22test222222testIoTDB|
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------+
```

另一个用于查询的 SQL 语句:

```sql
select s1, s2, concat(s1, s2, "target1"="IoT", "target2"="DB", "series_behind"="true") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------------------------------+
|                         Time|root.sg1.d1.s1|root.sg1.d1.s2|concat(root.sg1.d1.s1, root.sg1.d1.s2, "target1"="IoT", "target2"="DB", "series_behind"="true")|
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|          null|                                                                                    IoTDB1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|      2222test|                                                                          IoTDB22test222222test|
+-----------------------------+--------------+--------------+-----------------------------------------------------------------------------------------------+
```

###  Substr

####  函数简介

本函数用于获取下标从`start`到`end - 1`的子串

**函数名:** SUBSTR

**输入序列:** 仅支持单个输入序列，类型为TEXT。

**参数:**
+ `start`: 指定子串开始下标。
+ `end`: 指定子串结束下标。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, substr(s1, "start"="0", "end"="2") from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+----------------------------------------------+
|                         Time|root.sg1.d1.s1|substr(root.sg1.d1.s1, "start"="0", "end"="2")|
+-----------------------------+--------------+----------------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|                                            1t|
|1970-01-01T08:00:00.002+08:00|      22test22|                                            22|
+-----------------------------+--------------+----------------------------------------------+
```

###  Upper

####  函数简介

本函数用于将输入序列转化为大写。

**函数名:** UPPER

**输入序列:** 仅支持单个输入序列，类型为TEXT。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|
|1970-01-01T08:00:00.002+08:00|      22test22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, upper(s1) from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+---------------------+
|                         Time|root.sg1.d1.s1|upper(root.sg1.d1.s1)|
+-----------------------------+--------------+---------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|               1TEST1|
|1970-01-01T08:00:00.002+08:00|      22test22|             22TEST22|
+-----------------------------+--------------+---------------------+
```

###  Lower

####  函数简介

本函数用于将输入序列转换为小写。

**函数名:** LOWER

**输入序列:** 仅支持单个输入序列，类型为TEXT。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s1|
+-----------------------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1TEST1|
|1970-01-01T08:00:00.002+08:00|      22TEST22|
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, lower(s1) from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+---------------------+
|                         Time|root.sg1.d1.s1|lower(root.sg1.d1.s1)|
+-----------------------------+--------------+---------------------+
|1970-01-01T08:00:00.001+08:00|        1TEST1|               1test1|
|1970-01-01T08:00:00.002+08:00|      22TEST22|             22test22|
+-----------------------------+--------------+---------------------+
```

###  Trim

####  函数简介

本函数用于移除输入序列前后的空格。

**函数名:** TRIM

**输入序列:** 仅支持单个输入序列，类型为TEXT。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:** 如果输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+
|                         Time|root.sg1.d1.s3|
+-----------------------------+--------------+
|1970-01-01T08:00:00.002+08:00|   3querytest3|
|1970-01-01T08:00:00.003+08:00|  3querytest3 |
+-----------------------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s3, trim(s3) from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+--------------------+
|                         Time|root.sg1.d1.s3|trim(root.sg1.d1.s3)|
+-----------------------------+--------------+--------------------+
|1970-01-01T08:00:00.002+08:00|   3querytest3|         3querytest3|
|1970-01-01T08:00:00.003+08:00|  3querytest3 |         3querytest3|
+-----------------------------+--------------+--------------------+
```

###  StrCmp

####  函数简介

本函数用于比较两个输入序列。 如果值相同返回 `0` , 序列1的值小于序列2的值返回一个`负数`，序列1的值大于序列2的值返回一个`正数`。

**函数名:** StrCmp

**输入序列:** 输入两个序列，类型均为 TEXT。

**输出序列:** 输出单个序列，类型为 TEXT。

**提示:** 如果任何一个输入是NULL，返回NULL。

####  使用示例

输入序列:

```
+-----------------------------+--------------+--------------+
|                         Time|root.sg1.d1.s1|root.sg1.d1.s2|
+-----------------------------+--------------+--------------+
|1970-01-01T08:00:00.001+08:00|        1test1|          null|
|1970-01-01T08:00:00.002+08:00|      22test22|      2222test|
+-----------------------------+--------------+--------------+
```

用于查询的 SQL 语句:

```sql
select s1, s2, strcmp(s1, s2) from root.sg1.d1
```

输出序列:

```
+-----------------------------+--------------+--------------+--------------------------------------+
|                         Time|root.sg1.d1.s1|root.sg1.d1.s2|strcmp(root.sg1.d1.s1, root.sg1.d1.s2)|
+-----------------------------+--------------+--------------+--------------------------------------+
|1970-01-01T08:00:00.001+08:00|        1test1|          null|                                  null|
|1970-01-01T08:00:00.002+08:00|      22test22|      2222test|                                    66|
+-----------------------------+--------------+--------------+--------------------------------------+
```

###  StrReplace

####  函数简介

**非内置函数，需要注册数据质量函数库后才能使用。**本函数用于将文本中的子串替换为指定的字符串。

**函数名：** STRREPLACE

**输入序列：** 仅支持单个输入序列，类型为 TEXT。

**参数：**

+ `target`: 需要替换的字符子串
+ `replace`: 替换后的字符串。
+ `limit`: 替换次数，大于等于 -1 的整数，默认为 -1 表示所有匹配的子串都会被替换。
+ `offset`: 需要跳过的匹配次数，即前`offset`次匹配到的字符子串并不会被替换，默认为 0。
+ `reverse`: 是否需要反向计数，默认为 false 即按照从左向右的次序。

**输出序列：** 输出单个序列，类型为 TEXT。

####  使用示例

输入序列：

```
+-----------------------------+---------------+
|                         Time|root.test.d1.s1|
+-----------------------------+---------------+
|2021-01-01T00:00:01.000+08:00|      A,B,A+,B-|
|2021-01-01T00:00:02.000+08:00|      A,A+,A,B+|
|2021-01-01T00:00:03.000+08:00|         B+,B,B|
|2021-01-01T00:00:04.000+08:00|      A+,A,A+,A|
|2021-01-01T00:00:05.000+08:00|       A,B-,B,B|
+-----------------------------+---------------+
```

用于查询的 SQL 语句：

```sql
select strreplace(s1, "target"=",", "replace"="/", "limit"="2") from root.test.d1
```

输出序列：

```
+-----------------------------+-----------------------------------------+
|                         Time|strreplace(root.test.d1.s1, "target"=",",|
|                             |              "replace"="/", "limit"="2")|
+-----------------------------+-----------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                A/B/A+,B-|
|2021-01-01T00:00:02.000+08:00|                                A/A+/A,B+|
|2021-01-01T00:00:03.000+08:00|                                   B+/B/B|
|2021-01-01T00:00:04.000+08:00|                                A+/A/A+,A|
|2021-01-01T00:00:05.000+08:00|                                 A/B-/B,B|
+-----------------------------+-----------------------------------------+
```

另一个用于查询的 SQL 语句：

```sql
select strreplace(s1, "target"=",", "replace"="/", "limit"="1", "offset"="1", "reverse"="true") from root.test.d1
```

输出序列：

```
+-----------------------------+-----------------------------------------------------+
|                         Time|strreplace(root.test.d1.s1, "target"=",", "replace"= | 
|                             |    "|", "limit"="1", "offset"="1", "reverse"="true")|
+-----------------------------+-----------------------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                            A,B/A+,B-|
|2021-01-01T00:00:02.000+08:00|                                            A,A+/A,B+|
|2021-01-01T00:00:03.000+08:00|                                               B+/B,B|
|2021-01-01T00:00:04.000+08:00|                                            A+,A/A+,A|
|2021-01-01T00:00:05.000+08:00|                                             A,B-/B,B|
+-----------------------------+-----------------------------------------------------+
```

###  RegexMatch

####  函数简介

**非内置函数，需要注册数据质量函数库后才能使用。**本函数用于正则表达式匹配文本中的具体内容并返回。

**函数名：** REGEXMATCH

**输入序列：** 仅支持单个输入序列，类型为 TEXT。

**参数：**

+ `regex`: 匹配的正则表达式，支持所有 Java 正则表达式语法，比如`\d+\.\d+\.\d+\.\d+`将会匹配任意 IPv4 地址.
+ `group`: 输出的匹配组序号，根据 java.util.regex 规定，第 0 组为整个正则表达式，此后的组按照左括号出现的顺序依次编号。
  如`A(B(CD))`中共有三个组，第 0 组`A(B(CD))`，第 1 组`B(CD)`和第 2 组`CD`。

**输出序列：** 输出单个序列，类型为 TEXT。

**提示：** 空值或无法匹配给定的正则表达式的数据点没有输出结果。

####  使用示例


输入序列：

```
+-----------------------------+-------------------------------+
|                         Time|                root.test.d1.s1|
+-----------------------------+-------------------------------+
|2021-01-01T00:00:01.000+08:00|        [192.168.0.1] [SUCCESS]|
|2021-01-01T00:00:02.000+08:00|       [192.168.0.24] [SUCCESS]|
|2021-01-01T00:00:03.000+08:00|           [192.168.0.2] [FAIL]|
|2021-01-01T00:00:04.000+08:00|        [192.168.0.5] [SUCCESS]|
|2021-01-01T00:00:05.000+08:00|      [192.168.0.124] [SUCCESS]|
+-----------------------------+-------------------------------+
```

用于查询的 SQL 语句：

```sql
select regexmatch(s1, "regex"="\d+\.\d+\.\d+\.\d+", "group"="0") from root.test.d1
```

输出序列：

```
+-----------------------------+----------------------------------------------------------------------+
|                         Time|regexmatch(root.test.d1.s1, "regex"="\d+\.\d+\.\d+\.\d+", "group"="0")|
+-----------------------------+----------------------------------------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                                           192.168.0.1|
|2021-01-01T00:00:02.000+08:00|                                                          192.168.0.24|
|2021-01-01T00:00:03.000+08:00|                                                           192.168.0.2|
|2021-01-01T00:00:04.000+08:00|                                                           192.168.0.5|
|2021-01-01T00:00:05.000+08:00|                                                         192.168.0.124|
+-----------------------------+----------------------------------------------------------------------+
```

###  RegexReplace

####  函数简介

**非内置函数，需要注册数据质量函数库后才能使用。**本函数用于将文本中符合正则表达式的匹配结果替换为指定的字符串。

**函数名：** REGEXREPLACE

**输入序列：** 仅支持单个输入序列，类型为 TEXT。

**参数：**

+ `regex`: 需要替换的正则表达式，支持所有 Java 正则表达式语法。
+ `replace`: 替换后的字符串，支持 Java 正则表达式中的后向引用，
  形如'$1'指代了正则表达式`regex`中的第一个分组，并会在替换时自动填充匹配到的子串。
+ `limit`: 替换次数，大于等于 -1 的整数，默认为 -1 表示所有匹配的子串都会被替换。
+ `offset`: 需要跳过的匹配次数，即前`offset`次匹配到的字符子串并不会被替换，默认为 0。
+ `reverse`: 是否需要反向计数，默认为 false 即按照从左向右的次序。

**输出序列：** 输出单个序列，类型为 TEXT。

####  使用示例

输入序列：

```
+-----------------------------+-------------------------------+
|                         Time|                root.test.d1.s1|
+-----------------------------+-------------------------------+
|2021-01-01T00:00:01.000+08:00|        [192.168.0.1] [SUCCESS]|
|2021-01-01T00:00:02.000+08:00|       [192.168.0.24] [SUCCESS]|
|2021-01-01T00:00:03.000+08:00|           [192.168.0.2] [FAIL]|
|2021-01-01T00:00:04.000+08:00|        [192.168.0.5] [SUCCESS]|
|2021-01-01T00:00:05.000+08:00|      [192.168.0.124] [SUCCESS]|
+-----------------------------+-------------------------------+
```

用于查询的 SQL 语句：

```sql
select regexreplace(s1, "regex"="192\.168\.0\.(\d+)", "replace"="cluster-$1", "limit"="1") from root.test.d1
```

输出序列：

```
+-----------------------------+-----------------------------------------------------------+
|                         Time|regexreplace(root.test.d1.s1, "regex"="192\.168\.0\.(\d+)",|
|                             |                       "replace"="cluster-$1", "limit"="1")|
+-----------------------------+-----------------------------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                      [cluster-1] [SUCCESS]|
|2021-01-01T00:00:02.000+08:00|                                     [cluster-24] [SUCCESS]|
|2021-01-01T00:00:03.000+08:00|                                         [cluster-2] [FAIL]|
|2021-01-01T00:00:04.000+08:00|                                      [cluster-5] [SUCCESS]|
|2021-01-01T00:00:05.000+08:00|                                    [cluster-124] [SUCCESS]|
+-----------------------------+-----------------------------------------------------------+
```

###  RegexSplit

####  函数简介

**非内置函数，需要注册数据质量函数库后才能使用。**本函数用于使用给定的正则表达式切分文本，并返回指定的项。

**函数名：** REGEXSPLIT

**输入序列：** 仅支持单个输入序列，类型为 TEXT。

**参数：**

+ `regex`: 用于分割文本的正则表达式，支持所有 Java 正则表达式语法，比如`['"]`将会匹配任意的英文引号`'`和`"`。
+ `index`: 输出结果在切分后数组中的序号，需要是大于等于 -1 的整数，默认值为 -1 表示返回切分后数组的长度，其它非负整数即表示返回数组中对应位置的切分结果（数组的秩从 0 开始计数）。

**输出序列：** 输出单个序列，在`index`为 -1 时输出数据类型为 INT32，否则为 TEXT。

**提示：** 如果`index`超出了切分后结果数组的秩范围，例如使用`,`切分`0,1,2`时输入`index`为 3，则该数据点没有输出结果。

####  使用示例


输入序列：

```
+-----------------------------+---------------+
|                         Time|root.test.d1.s1|
+-----------------------------+---------------+
|2021-01-01T00:00:01.000+08:00|      A,B,A+,B-|
|2021-01-01T00:00:02.000+08:00|      A,A+,A,B+|
|2021-01-01T00:00:03.000+08:00|         B+,B,B|
|2021-01-01T00:00:04.000+08:00|      A+,A,A+,A|
|2021-01-01T00:00:05.000+08:00|       A,B-,B,B|
+-----------------------------+---------------+
```

用于查询的 SQL 语句：

```sql
select regexsplit(s1, "regex"=",", "index"="-1") from root.test.d1
```

输出序列：

```
+-----------------------------+------------------------------------------------------+
|                         Time|regexsplit(root.test.d1.s1, "regex"=",", "index"="-1")|
+-----------------------------+------------------------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                                     4|
|2021-01-01T00:00:02.000+08:00|                                                     4|
|2021-01-01T00:00:03.000+08:00|                                                     3|
|2021-01-01T00:00:04.000+08:00|                                                     4|
|2021-01-01T00:00:05.000+08:00|                                                     4|
+-----------------------------+------------------------------------------------------+
```

另一个查询的 SQL 语句：

```sql
select regexsplit(s1, "regex"=",", "index"="3") from root.test.d1
```

输出序列：

```
+-----------------------------+-----------------------------------------------------+
|                         Time|regexsplit(root.test.d1.s1, "regex"=",", "index"="3")|
+-----------------------------+-----------------------------------------------------+
|2021-01-01T00:00:01.000+08:00|                                                   B-|
|2021-01-01T00:00:02.000+08:00|                                                   B+|
|2021-01-01T00:00:04.000+08:00|                                                    A|
|2021-01-01T00:00:05.000+08:00|                                                    B|
+-----------------------------+-----------------------------------------------------+
```
