/**
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.iotdb.db.metrics.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.iotdb.db.metrics.ui.MetricsPage;
import org.apache.iotdb.db.service.TSServiceImpl;

public class QueryServlet extends HttpServlet {

  private static final long serialVersionUID = 1L;

  private List<SqlArgument> list = TSServiceImpl.sqlArgumentsList;
  private MetricsPage page;

  public QueryServlet(MetricsPage page) {
    this.page = page;
    this.page.setList(list);
  }

  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    resp.setContentType("text/html;charset=utf-8");
    req.setCharacterEncoding("utf-8");
    resp.setStatus(HttpServletResponse.SC_OK);
    resp.setIntHeader("refresh", 300);
    PrintWriter out = resp.getWriter();
    out.print(page.render());
    out.flush();
    out.close();
  }

  @Override
  protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    doGet(req, resp);
  }
}
