/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchemaType;

public class MeasurementSchema
implements IMeasurementSchema,
Comparable<MeasurementSchema>,
Serializable {
    private String measurementId;
    private byte type;
    private byte encoding;
    private TSEncodingBuilder encodingConverter;
    private byte compressor;
    private Map<String, String> props = null;

    public MeasurementSchema() {
    }

    public MeasurementSchema(String measurementId, TSDataType tsDataType) {
        this(measurementId, tsDataType, TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getValueEncoder()), TSFileDescriptor.getInstance().getConfig().getCompressor(), null);
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding) {
        this(measurementId, type, encoding, TSFileDescriptor.getInstance().getConfig().getCompressor(), null);
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding, CompressionType compressionType) {
        this(measurementId, type, encoding, compressionType, null);
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding, CompressionType compressionType, Map<String, String> props) {
        this.type = type.serialize();
        this.measurementId = measurementId;
        this.encoding = encoding.serialize();
        this.props = props;
        this.compressor = compressionType.serialize();
    }

    public MeasurementSchema(String measurementId, byte type, byte encoding, byte compressionType, Map<String, String> props) {
        this.type = type;
        this.measurementId = measurementId;
        this.encoding = encoding;
        this.props = props;
        this.compressor = compressionType;
    }

    public static MeasurementSchema deserializeFrom(InputStream inputStream) throws IOException {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementId = ReadWriteIOUtils.readString(inputStream);
        measurementSchema.type = ReadWriteIOUtils.readByte(inputStream);
        measurementSchema.encoding = ReadWriteIOUtils.readByte(inputStream);
        measurementSchema.compressor = ReadWriteIOUtils.readByte(inputStream);
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                String value = ReadWriteIOUtils.readString(inputStream);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public static MeasurementSchema deserializeFrom(ByteBuffer buffer) {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementId = ReadWriteIOUtils.readString(buffer);
        measurementSchema.type = ReadWriteIOUtils.readByte(buffer);
        measurementSchema.encoding = ReadWriteIOUtils.readByte(buffer);
        measurementSchema.compressor = ReadWriteIOUtils.readByte(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                String value = ReadWriteIOUtils.readString(buffer);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public static MeasurementSchema partialDeserializeFrom(ByteBuffer buffer) {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementId = ReadWriteIOUtils.readString(buffer);
        measurementSchema.type = ReadWriteIOUtils.readByte(buffer);
        measurementSchema.encoding = ReadWriteIOUtils.readByte(buffer);
        measurementSchema.compressor = ReadWriteIOUtils.readByte(buffer);
        return measurementSchema;
    }

    @Override
    public MeasurementSchemaType getSchemaType() {
        return MeasurementSchemaType.MEASUREMENT_SCHEMA;
    }

    @Override
    public String getMeasurementId() {
        return this.measurementId;
    }

    public void setMeasurementId(String measurementId) {
        this.measurementId = measurementId;
    }

    @Override
    public Map<String, String> getProps() {
        return this.props;
    }

    @Override
    public TSEncoding getEncodingType() {
        return TSEncoding.deserialize(this.encoding);
    }

    @Override
    public TSDataType getType() {
        return TSDataType.deserialize((byte)this.type);
    }

    @Override
    public byte getTypeInByte() {
        return this.type;
    }

    @Override
    public TSEncoding getTimeTSEncoding() {
        return TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public Encoder getTimeEncoder() {
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        return TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType);
    }

    @Override
    public List<String> getSubMeasurementsList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<TSDataType> getSubMeasurementsTSDataTypeList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<TSEncoding> getSubMeasurementsTSEncodingList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public List<Encoder> getSubMeasurementsEncoderList() {
        throw new UnsupportedOperationException("unsupported method for MeasurementSchema");
    }

    @Override
    public Encoder getValueEncoder() {
        if (this.encodingConverter == null) {
            this.encodingConverter = TSEncodingBuilder.getEncodingBuilder(TSEncoding.deserialize(this.encoding));
            this.encodingConverter.initFromProps(this.props);
        }
        return this.encodingConverter.getEncoder(TSDataType.deserialize((byte)this.type));
    }

    @Override
    public CompressionType getCompressor() {
        return CompressionType.deserialize(this.compressor);
    }

    @Override
    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.type, outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        byteLen += ReadWriteIOUtils.write(this.compressor, outputStream);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), outputStream);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    @Override
    public int serializedSize() {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.sizeToWrite(this.measurementId);
        byteLen += 3;
        if (this.props == null) {
            byteLen += 4;
        } else {
            byteLen += 4;
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.sizeToWrite(entry.getKey());
                byteLen += ReadWriteIOUtils.sizeToWrite(entry.getValue());
            }
        }
        return byteLen;
    }

    @Override
    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementId, buffer);
        byteLen += ReadWriteIOUtils.write(this.type, buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        byteLen += ReadWriteIOUtils.write(this.compressor, buffer);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), buffer);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), buffer);
            }
        }
        return byteLen;
    }

    @Override
    public int partialSerializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((byte)0, outputStream);
        byteLen += ReadWriteIOUtils.write(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.type, outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.compressor, outputStream);
    }

    @Override
    public boolean isLogicalView() {
        return false;
    }

    @Override
    public int partialSerializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((byte)0, buffer);
        byteLen += ReadWriteIOUtils.write(this.measurementId, buffer);
        byteLen += ReadWriteIOUtils.write(this.type, buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        return byteLen += ReadWriteIOUtils.write(this.compressor, buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementSchema that = (MeasurementSchema)o;
        return this.type == that.type && this.encoding == that.encoding && Objects.equals(this.measurementId, that.measurementId) && Objects.equals(this.compressor, that.compressor);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.encoding, this.measurementId, this.compressor);
    }

    @Override
    public int compareTo(MeasurementSchema o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.measurementId.compareTo(o.measurementId);
    }

    public String toString() {
        StringContainer sc = new StringContainer("");
        sc.addTail("[", this.measurementId, ",", TSDataType.deserialize((byte)this.type).toString(), ",", TSEncoding.deserialize(this.encoding).toString(), ",", this.props == null ? "" : this.props.toString(), ",", CompressionType.deserialize(this.compressor).toString());
        sc.addTail("]");
        return sc.toString();
    }

    @Override
    public void setType(TSDataType type) {
        this.type = type.serialize();
    }

    @Override
    public int getSubMeasurementIndex(String measurementId) {
        return this.measurementId.equals(measurementId) ? 0 : -1;
    }

    @Override
    public int getSubMeasurementsCount() {
        return 1;
    }

    @Override
    public boolean containsSubMeasurement(String measurementId) {
        return this.measurementId.equals(measurementId);
    }

    public void setEncoding(byte encoding) {
        this.encoding = encoding;
    }

    public void setCompressor(byte compressor) {
        this.compressor = compressor;
    }
}

