/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.series.AbstractFileSeriesReader;

public class FileSeriesReader
extends AbstractFileSeriesReader {
    public FileSeriesReader(IChunkLoader chunkLoader, List<IChunkMetadata> chunkMetadataList, Filter filter) {
        super(chunkLoader, chunkMetadataList, filter);
    }

    @Override
    protected void initChunkReader(IChunkMetadata chunkMetaData) throws IOException {
        if (chunkMetaData instanceof ChunkMetadata) {
            Chunk chunk = this.chunkLoader.loadChunk((ChunkMetadata)chunkMetaData);
            this.chunkReader = new ChunkReader(chunk, this.filter);
        } else {
            AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
            Chunk timeChunk = this.chunkLoader.loadChunk((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata metadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                valueChunkList.add(this.chunkLoader.loadChunk((ChunkMetadata)metadata));
            }
            this.chunkReader = new AlignedChunkReader(timeChunk, valueChunkList, this.filter, false);
        }
    }

    @Override
    protected boolean chunkSatisfied(IChunkMetadata chunkMetaData) {
        return this.filter == null || this.filter.satisfy(chunkMetaData.getStatistics());
    }
}

