/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;

public class NotFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 584860326604020881L;
    private Filter that;
    public static final String CONTAIN_NOT_ERR_MSG = "This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ";

    public NotFilter() {
    }

    public NotFilter(Filter that) {
        this.that = that;
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        throw new UnsupportedOperationException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean allSatisfy(Statistics statistics) {
        throw new UnsupportedOperationException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return !this.that.satisfy(time, value);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        throw new UnsupportedOperationException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        throw new UnsupportedOperationException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public Filter copy() {
        return new NotFilter(this.that.copy());
    }

    public Filter getFilter() {
        return this.that;
    }

    public String toString() {
        return "not (" + this.that + ")";
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            this.that.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.that = FilterFactory.deserialize(buffer);
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.NOT;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotFilter)) {
            return false;
        }
        NotFilter other = (NotFilter)obj;
        return this.that.equals(other.that);
    }

    public int hashCode() {
        return Objects.hash(this.that);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        List<TimeRange> list = this.that.getTimeRanges();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<TimeRange> res = new ArrayList<TimeRange>();
        if (list.get(0).getMin() != Long.MIN_VALUE) {
            res.add(new TimeRange(Long.MIN_VALUE, list.get(0).getMin() - 1L));
        }
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            long right;
            long left = list.get(i - 1).getMax() + 1L;
            if (left > (right = list.get(i).getMin() - 1L)) continue;
            res.add(new TimeRange(left, right));
        }
        if (list.get(list.size() - 1).getMax() != Long.MAX_VALUE) {
            res.add(new TimeRange(list.get(list.size() - 1).getMax() + 1L, Long.MAX_VALUE));
        }
        return res;
    }

    @Override
    public Filter reverse() {
        return this.that;
    }
}

