/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.factory;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.filter.operator.Between;
import org.apache.iotdb.tsfile.read.filter.operator.Eq;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.apache.iotdb.tsfile.read.filter.operator.Like;
import org.apache.iotdb.tsfile.read.filter.operator.Lt;
import org.apache.iotdb.tsfile.read.filter.operator.LtEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotEq;
import org.apache.iotdb.tsfile.read.filter.operator.NotFilter;
import org.apache.iotdb.tsfile.read.filter.operator.OrFilter;
import org.apache.iotdb.tsfile.read.filter.operator.Regexp;

public class FilterFactory {
    private FilterFactory() {
    }

    public static AndFilter and(Filter left, Filter right) {
        return new AndFilter(left, right);
    }

    public static OrFilter or(Filter left, Filter right) {
        return new OrFilter(left, right);
    }

    public static NotFilter not(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter deserialize(ByteBuffer buffer) {
        Filter filter;
        FilterSerializeId id = FilterSerializeId.values()[buffer.get()];
        switch (id) {
            case EQ: {
                filter = new Eq();
                break;
            }
            case GT: {
                filter = new Gt();
                break;
            }
            case LT: {
                filter = new Lt();
                break;
            }
            case OR: {
                filter = new OrFilter();
                break;
            }
            case AND: {
                filter = new AndFilter();
                break;
            }
            case NEQ: {
                filter = new NotEq();
                break;
            }
            case NOT: {
                filter = new NotFilter();
                break;
            }
            case GTEQ: {
                filter = new GtEq();
                break;
            }
            case LTEQ: {
                filter = new LtEq();
                break;
            }
            case IN: {
                filter = new In();
                break;
            }
            case GROUP_BY: {
                filter = new GroupByFilter();
                break;
            }
            case GROUP_BY_MONTH: {
                filter = new GroupByMonthFilter();
                break;
            }
            case REGEXP: {
                filter = new Regexp();
                break;
            }
            case LIKE: {
                filter = new Like();
                break;
            }
            case BETWEEN: {
                filter = new Between();
                break;
            }
            case TIME_GTEQ_AND_LT: {
                filter = new TimeFilter.TimeGtEqAndLt();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown filter type " + (Object)((Object)id));
            }
        }
        filter.deserialize(buffer);
        return filter;
    }
}

