/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.expression.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SingleSeriesExpression
implements IUnaryExpression,
Serializable {
    private static final long serialVersionUID = 7131207370394865228L;
    private Path seriesPath;
    private Filter filter;

    public SingleSeriesExpression(Path seriesDescriptor, Filter filter) {
        this.seriesPath = seriesDescriptor;
        this.filter = filter;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.SERIES;
    }

    @Override
    public IExpression clone() {
        return new SingleSeriesExpression(this.seriesPath.clone(), this.filter.copy());
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)this.getType().ordinal(), byteBuffer);
        this.seriesPath.serialize(byteBuffer);
        this.filter.serialize(byteBuffer);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String toString() {
        return "[" + this.seriesPath + ":" + this.filter + "]";
    }

    public Path getSeriesPath() {
        return this.seriesPath;
    }

    public void setSeriesPath(Path seriesPath) {
        this.seriesPath = seriesPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleSeriesExpression that = (SingleSeriesExpression)o;
        return Objects.equals(this.toString(), that.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }
}

