/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PerformanceOverviewMetrics
implements IMetricSet {
    private static final Map<String, MetricInfo> metricInfoMap = new HashMap<String, MetricInfo>();
    private static final String PERFORMANCE_OVERVIEW_DETAIL = Metric.PERFORMANCE_OVERVIEW_DETAIL.toString();
    private static final String AUTHORITY = "authority";
    private static final String PARSER = "parser";
    private static final String ANALYZER = "analyzer";
    private static final String PLANNER = "planner";
    private static final String SCHEDULER = "scheduler";
    private Timer authTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer parseTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer analyzeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer planTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer scheduleTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL;
    private static final String LOCAL_SCHEDULE = "local_scheduler";
    private static final String REMOTE_SCHEDULE = "remote_scheduler";
    private Timer localScheduleTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer remoteScheduleTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String PERFORMANCE_OVERVIEW_LOCAL_DETAIL;
    private static final String SCHEMA_VALIDATE = "schema_validate";
    private static final String TRIGGER = "trigger";
    private static final String STORAGE = "storage";
    private Timer schemaValidateTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer triggerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer storageTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String PERFORMANCE_OVERVIEW_STORAGE_DETAIL;
    private static final String ENGINE = "engine";
    private Timer engineTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String PERFORMANCE_OVERVIEW_ENGINE_DETAIL;
    private static final String LOCK = "lock";
    private static final String MEMORY_BLOCK = "memory_block";
    private static final String CREATE_MEMTABLE_BLOCK = "create_memtable_block";
    private static final String WAL = "wal";
    private static final String MEMTABLE = "memtable";
    private static final String LAST_CACHE = "last_cache";
    private Timer lockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer createMemtableBlockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer memoryBlockTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer walTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer memtableTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer lastCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private PerformanceOverviewMetrics() {
    }

    public void recordAuthCost(long costTimeInNanos) {
        this.authTimer.updateNanos(costTimeInNanos);
    }

    public void recordParseCost(long costTimeInNanos) {
        this.parseTimer.updateNanos(costTimeInNanos);
    }

    public void recordAnalyzeCost(long costTimeInNanos) {
        this.analyzeTimer.updateNanos(costTimeInNanos);
    }

    public void recordPlanCost(long costTimeInNanos) {
        this.planTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleCost(long costTimeInNanos) {
        this.scheduleTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleLocalCost(long costTimeInNanos) {
        this.localScheduleTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleRemoteCost(long costTimeInNanos) {
        this.remoteScheduleTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleSchemaValidateCost(long costTimeInNanos) {
        this.schemaValidateTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleTriggerCost(long costTimeInNanos) {
        this.triggerTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleStorageCost(long costTimeInNanos) {
        this.storageTimer.updateNanos(costTimeInNanos);
    }

    public void recordEngineCost(long costTimeInNanos) {
        this.engineTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleLockCost(long costTimeInNanos) {
        this.lockTimer.updateNanos(costTimeInNanos);
    }

    public void recordCreateMemtableBlockCost(long costTimeInNanos) {
        this.createMemtableBlockTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleMemoryBlockCost(long costTimeInNanos) {
        this.memoryBlockTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleWalCost(long costTimeInNanos) {
        this.walTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleMemTableCost(long costTimeInNanos) {
        this.memtableTimer.updateNanos(costTimeInNanos);
    }

    public void recordScheduleUpdateLastCacheCost(long costTimeInNanos) {
        this.lastCacheTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.authTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), AUTHORITY});
        this.parseTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), PARSER});
        this.analyzeTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), ANALYZER});
        this.planTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), PLANNER});
        this.scheduleTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), SCHEDULER});
        this.localScheduleTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), LOCAL_SCHEDULE});
        this.remoteScheduleTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), REMOTE_SCHEDULE});
        this.schemaValidateTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_LOCAL_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), SCHEMA_VALIDATE});
        this.triggerTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_LOCAL_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), TRIGGER});
        this.storageTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_LOCAL_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), STORAGE});
        this.engineTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_STORAGE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), ENGINE});
        this.lockTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), LOCK});
        this.createMemtableBlockTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), CREATE_MEMTABLE_BLOCK});
        this.memoryBlockTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), MEMORY_BLOCK});
        this.walTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), WAL});
        this.memtableTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), MEMTABLE});
        this.lastCacheTimer = metricService.getOrCreateTimer(PERFORMANCE_OVERVIEW_ENGINE_DETAIL, MetricLevel.CORE, new String[]{Tag.STAGE.toString(), LAST_CACHE});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.remove(MetricType.TIMER, metricInfo.getName(), metricInfo.getTagsInArray());
        }
    }

    public static PerformanceOverviewMetrics getInstance() {
        return PerformanceOverviewMetricsHolder.INSTANCE;
    }

    static {
        metricInfoMap.put(AUTHORITY, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_DETAIL, new String[]{Tag.STAGE.toString(), AUTHORITY}));
        metricInfoMap.put(PARSER, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_DETAIL, new String[]{Tag.STAGE.toString(), PARSER}));
        metricInfoMap.put(ANALYZER, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_DETAIL, new String[]{Tag.STAGE.toString(), ANALYZER}));
        metricInfoMap.put(PLANNER, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_DETAIL, new String[]{Tag.STAGE.toString(), PLANNER}));
        metricInfoMap.put(SCHEDULER, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_DETAIL, new String[]{Tag.STAGE.toString(), SCHEDULER}));
        PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL = Metric.PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL.toString();
        metricInfoMap.put(LOCAL_SCHEDULE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL, new String[]{Tag.STAGE.toString(), LOCAL_SCHEDULE}));
        metricInfoMap.put(REMOTE_SCHEDULE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_SCHEDULE_DETAIL, new String[]{Tag.STAGE.toString(), REMOTE_SCHEDULE}));
        PERFORMANCE_OVERVIEW_LOCAL_DETAIL = Metric.PERFORMANCE_OVERVIEW_LOCAL_DETAIL.toString();
        metricInfoMap.put(SCHEMA_VALIDATE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_LOCAL_DETAIL, new String[]{Tag.STAGE.toString(), SCHEMA_VALIDATE}));
        metricInfoMap.put(TRIGGER, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_LOCAL_DETAIL, new String[]{Tag.STAGE.toString(), TRIGGER}));
        metricInfoMap.put(STORAGE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_LOCAL_DETAIL, new String[]{Tag.STAGE.toString(), STORAGE}));
        PERFORMANCE_OVERVIEW_STORAGE_DETAIL = Metric.PERFORMANCE_OVERVIEW_STORAGE_DETAIL.toString();
        metricInfoMap.put(ENGINE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_STORAGE_DETAIL, new String[]{Tag.STAGE.toString(), ENGINE}));
        PERFORMANCE_OVERVIEW_ENGINE_DETAIL = Metric.PERFORMANCE_OVERVIEW_ENGINE_DETAIL.toString();
        metricInfoMap.put(LOCK, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), LOCK}));
        metricInfoMap.put(CREATE_MEMTABLE_BLOCK, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), CREATE_MEMTABLE_BLOCK}));
        metricInfoMap.put(MEMORY_BLOCK, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), MEMORY_BLOCK}));
        metricInfoMap.put(WAL, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), WAL}));
        metricInfoMap.put(MEMTABLE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), MEMTABLE}));
        metricInfoMap.put(LAST_CACHE, new MetricInfo(MetricType.TIMER, PERFORMANCE_OVERVIEW_ENGINE_DETAIL, new String[]{Tag.STAGE.toString(), LAST_CACHE}));
    }

    private static class PerformanceOverviewMetricsHolder {
        private static final PerformanceOverviewMetrics INSTANCE = new PerformanceOverviewMetrics();

        private PerformanceOverviewMetricsHolder() {
        }
    }
}

