/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(JMXService.class);

    public static void registerMBean(Object mbean, String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(mbean, objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.error("Failed to registerMBean {}", (Object)name, (Object)e);
        }
    }

    public static void deregisterMBean(String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            logger.error("Failed to unregisterMBean {}", (Object)name, (Object)e);
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.JMX_SERVICE;
    }

    @Override
    public void start() {
        String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
        if (jmxPort == null) {
            logger.debug("{} JMX port is undefined", (Object)this.getID().getName());
        }
    }

    @Override
    public void stop() {
    }
}

