/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node.common;

import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.info.IDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;

public abstract class AbstractDeviceMNode<N extends IMNode<N>, BasicNode extends IMNode<N>>
implements IDeviceMNode<N> {
    private final IDeviceInfo<N> deviceInfo;
    protected final BasicNode basicMNode;

    public AbstractDeviceMNode(BasicNode basicMNode, IDeviceInfo<N> deviceInfo) {
        this.basicMNode = basicMNode;
        this.deviceInfo = deviceInfo;
    }

    public BasicNode getBasicMNode() {
        return this.basicMNode;
    }

    @Override
    public String getName() {
        return this.basicMNode.getName();
    }

    @Override
    public void setName(String name) {
        this.basicMNode.setName(name);
    }

    @Override
    public N getParent() {
        return this.basicMNode.getParent();
    }

    @Override
    public void setParent(N parent) {
        this.basicMNode.setParent(parent);
    }

    @Override
    public String getFullPath() {
        return this.basicMNode.getFullPath();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.basicMNode.setFullPath(fullPath);
    }

    @Override
    public PartialPath getPartialPath() {
        return this.basicMNode.getPartialPath();
    }

    @Override
    public boolean hasChild(String name) {
        return this.basicMNode.hasChild(name) || this.deviceInfo.hasAliasChild(name);
    }

    @Override
    public N getChild(String name) {
        Object res = this.basicMNode.getChild(name);
        if (res == null) {
            res = this.deviceInfo.getAliasChild(name);
        }
        return res;
    }

    @Override
    public N addChild(String name, N child) {
        N res = this.basicMNode.addChild(name, child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N addChild(N child) {
        N res = this.basicMNode.addChild(child);
        if (res == child) {
            child.setParent(this.getAsMNode());
        }
        return res;
    }

    @Override
    public N deleteChild(String name) {
        return this.basicMNode.deleteChild(name);
    }

    @Override
    public void replaceChild(String oldChildName, N newChildNode) {
        this.basicMNode.replaceChild(oldChildName, newChildNode);
    }

    @Override
    public void moveDataToNewMNode(N newMNode) {
        this.basicMNode.moveDataToNewMNode(newMNode);
        if (newMNode.isDevice()) {
            this.deviceInfo.moveDataToNewMNode(newMNode.getAsDeviceMNode());
        }
    }

    @Override
    public IMNodeContainer<N> getChildren() {
        return this.basicMNode.getChildren();
    }

    @Override
    public void setChildren(IMNodeContainer<N> children) {
        this.basicMNode.setChildren(children);
    }

    @Override
    public boolean isAboveDatabase() {
        return false;
    }

    @Override
    public boolean isDatabase() {
        return false;
    }

    @Override
    public boolean isDevice() {
        return true;
    }

    @Override
    public boolean isMeasurement() {
        return false;
    }

    @Override
    public MNodeType getMNodeType(Boolean isConfig) {
        return MNodeType.DEVICE;
    }

    @Override
    public IDatabaseMNode<N> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IDeviceMNode<N> getAsDeviceMNode() {
        return this;
    }

    @Override
    public IMeasurementMNode<N> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceMNode(this, context);
    }

    @Override
    public boolean addAlias(String alias, IMeasurementMNode<N> child) {
        return this.deviceInfo.addAlias(alias, child);
    }

    @Override
    public void deleteAliasChild(String alias) {
        this.deviceInfo.deleteAliasChild(alias);
    }

    @Override
    public Map<String, IMeasurementMNode<N>> getAliasChildren() {
        return this.deviceInfo.getAliasChildren();
    }

    @Override
    public void setAliasChildren(Map<String, IMeasurementMNode<N>> aliasChildren) {
        this.deviceInfo.setAliasChildren(aliasChildren);
    }

    @Override
    public boolean isUseTemplate() {
        return this.deviceInfo.isUseTemplate();
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.deviceInfo.setUseTemplate(useTemplate);
    }

    @Override
    public void setSchemaTemplateId(int schemaTemplateId) {
        this.deviceInfo.setSchemaTemplateId(schemaTemplateId);
    }

    @Override
    public int getSchemaTemplateId() {
        return this.deviceInfo.getSchemaTemplateId();
    }

    @Override
    public int getSchemaTemplateIdWithState() {
        return this.deviceInfo.getSchemaTemplateIdWithState();
    }

    @Override
    public boolean isPreDeactivateTemplate() {
        return this.deviceInfo.isPreDeactivateTemplate();
    }

    @Override
    public void preDeactivateTemplate() {
        this.deviceInfo.preDeactivateTemplate();
    }

    @Override
    public void rollbackPreDeactivateTemplate() {
        this.deviceInfo.rollbackPreDeactivateTemplate();
    }

    @Override
    public void deactivateTemplate() {
        this.deviceInfo.deactivateTemplate();
    }

    @Override
    public boolean isAligned() {
        Boolean align = this.deviceInfo.isAligned();
        if (align == null) {
            return false;
        }
        return align;
    }

    @Override
    public Boolean isAlignedNullable() {
        return this.deviceInfo.isAligned();
    }

    @Override
    public void setAligned(Boolean isAligned) {
        this.deviceInfo.setAligned(isAligned);
    }

    @Override
    public int estimateSize() {
        return 16 + this.deviceInfo.estimateSize() + this.basicMNode.estimateSize();
    }
}

