/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.DoNothingConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBLegacyPipeConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftAsyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.IoTDBThriftSyncConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.WebSocketConnector;
import org.apache.iotdb.commons.pipe.plugin.builtin.extractor.IoTDBExtractor;
import org.apache.iotdb.commons.pipe.plugin.builtin.processor.DoNothingProcessor;

public enum BuiltinPipePlugin {
    IOTDB_EXTRACTOR("iotdb-extractor", IoTDBExtractor.class),
    IOTDB_SOURCE("iotdb-source", IoTDBExtractor.class),
    DO_NOTHING_PROCESSOR("do-nothing-processor", DoNothingProcessor.class),
    DO_NOTHING_CONNECTOR("do-nothing-connector", DoNothingConnector.class),
    IOTDB_THRIFT_CONNECTOR("iotdb-thrift-connector", IoTDBThriftConnector.class),
    IOTDB_THRIFT_SYNC_CONNECTOR("iotdb-thrift-sync-connector", IoTDBThriftSyncConnector.class),
    IOTDB_THRIFT_ASYNC_CONNECTOR("iotdb-thrift-async-connector", IoTDBThriftAsyncConnector.class),
    IOTDB_LEGACY_PIPE_CONNECTOR("iotdb-legacy-pipe-connector", IoTDBLegacyPipeConnector.class),
    WEBSOCKET_CONNECTOR("websocket-connector", WebSocketConnector.class),
    DO_NOTHING_SINK("do-nothing-sink", DoNothingConnector.class),
    IOTDB_THRIFT_SINK("iotdb-thrift-sink", IoTDBThriftConnector.class),
    IOTDB_THRIFT_SYNC_SINK("iotdb-thrift-sync-sink", IoTDBThriftSyncConnector.class),
    IOTDB_THRIFT_ASYNC_SINK("iotdb-thrift-async-sink", IoTDBThriftAsyncConnector.class),
    IOTDB_LEGACY_PIPE_SINK("iotdb-legacy-pipe-sink", IoTDBLegacyPipeConnector.class),
    WEBSOCKET_SINK("websocket-sink", WebSocketConnector.class);

    private final String pipePluginName;
    private final Class<?> pipePluginClass;
    private final String className;
    public static final Set<String> SHOW_PIPE_PLUGINS_BLACKLIST;

    private BuiltinPipePlugin(String pipePluginName, Class<?> pipePluginClass) {
        this.pipePluginName = pipePluginName;
        this.pipePluginClass = pipePluginClass;
        this.className = pipePluginClass.getName();
    }

    public String getPipePluginName() {
        return this.pipePluginName;
    }

    public Class<?> getPipePluginClass() {
        return this.pipePluginClass;
    }

    public String getClassName() {
        return this.className;
    }

    static {
        SHOW_PIPE_PLUGINS_BLACKLIST = new HashSet<String>();
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_EXTRACTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(DO_NOTHING_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_THRIFT_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(WEBSOCKET_CONNECTOR.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_THRIFT_SYNC_SINK.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_THRIFT_ASYNC_SINK.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(IOTDB_LEGACY_PIPE_SINK.getPipePluginName().toUpperCase());
        SHOW_PIPE_PLUGINS_BLACKLIST.add(WEBSOCKET_SINK.getPipePluginName().toUpperCase());
    }
}

