/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.dfa.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.dfa.DFAState;
import org.apache.iotdb.commons.path.fa.dfa.graph.Closure;
import org.apache.iotdb.commons.path.fa.dfa.graph.NFAGraph;

public class DFAGraph {
    private final List<IFAState> dfaStateList = new ArrayList<IFAState>();
    private final List<IFAState>[] dfaTransitionTable;

    public DFAGraph(NFAGraph nfaGraph, Collection<IFATransition> transitions) {
        this.dfaTransitionTable = new List[transitions.size()];
        int closureSize = nfaGraph.getStateSize();
        int index = 0;
        HashMap<Closure, DFAState> closureStateMap = new HashMap<Closure, DFAState>();
        for (IFATransition transition : transitions) {
            this.dfaTransitionTable[transition.getIndex()] = new ArrayList<IFAState>();
            this.dfaTransitionTable[transition.getIndex()].add(null);
        }
        DFAState curState = new DFAState(index);
        this.dfaStateList.add(curState);
        Closure curClosure = new Closure(closureSize);
        curClosure.addState(curState);
        closureStateMap.put(curClosure, curState);
        Stack<Closure> closureStack = new Stack<Closure>();
        closureStack.push(curClosure);
        while (!closureStack.isEmpty()) {
            curClosure = (Closure)closureStack.pop();
            Iterator<IFATransition> iterator = transitions.iterator();
            while (iterator.hasNext()) {
                Closure nextClosure = new Closure(closureSize);
                IFATransition transition = iterator.next();
                boolean isEmpty = this.getNextClosure(nfaGraph, curClosure, nextClosure, transition);
                if (isEmpty) continue;
                if (closureStateMap.containsKey(nextClosure)) {
                    this.dfaTransitionTable[transition.getIndex()].set(((DFAState)closureStateMap.get(curClosure)).getIndex(), (IFAState)closureStateMap.get(nextClosure));
                    continue;
                }
                DFAState newState = new DFAState(++index, nextClosure.isFinal());
                this.dfaStateList.add(newState);
                closureStateMap.put(nextClosure, newState);
                for (List<IFAState> column : this.dfaTransitionTable) {
                    column.add(null);
                }
                this.dfaTransitionTable[transition.getIndex()].set(((DFAState)closureStateMap.get(curClosure)).getIndex(), newState);
                closureStack.push(nextClosure);
            }
        }
    }

    public void print(Map<String, IFATransition> transitionMap) {
        System.out.println();
        System.out.println();
        System.out.println("DFA:");
        System.out.println("==================================================================================================");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("|%-15s|", "State"));
        for (IFATransition transfer : transitionMap.values()) {
            stringBuilder.append(String.format("%-15s|", transfer.toString()));
        }
        stringBuilder.append(String.format("%-15s|", "Final"));
        System.out.println(stringBuilder);
        for (int i = 0; i < this.dfaStateList.size(); ++i) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("|%-15d|", i));
            for (IFATransition transition : transitionMap.values()) {
                IFAState tmp = this.dfaTransitionTable[transition.getIndex()].get(i);
                stringBuilder.append(String.format("%-15s|", tmp == null ? "" : Integer.valueOf(tmp.getIndex())));
            }
            stringBuilder.append(String.format("%-15s|", this.dfaStateList.get(i).isFinal()));
            System.out.println(stringBuilder);
        }
    }

    private boolean getNextClosure(NFAGraph nfaGraph, Closure curClosure, Closure nextClosure, IFATransition transfer) {
        boolean isEmpty = true;
        for (IFAState state : curClosure.getStates()) {
            if (state == null) continue;
            for (IFAState nextState : nfaGraph.getTransitions(transfer, state)) {
                nextClosure.addState(nextState);
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    public Map<String, IFATransition> getPreciseMatchTransition(IFAState state, Collection<IFATransition> transitions) {
        HashMap<String, IFATransition> res = new HashMap<String, IFATransition>();
        for (IFATransition transition : transitions) {
            if (this.dfaTransitionTable[transition.getIndex()].get(state.getIndex()) == null) continue;
            res.put(transition.getAcceptEvent(), transition);
        }
        return res;
    }

    public List<IFATransition> getTransition(IFAState state, Collection<IFATransition> transitionList) {
        ArrayList<IFATransition> res = new ArrayList<IFATransition>();
        for (IFATransition transition : transitionList) {
            if (this.dfaTransitionTable[transition.getIndex()].get(state.getIndex()) == null) continue;
            res.add(transition);
        }
        return res;
    }

    public IFAState getNextState(IFAState currentState, IFATransition transition) {
        return this.dfaTransitionTable[transition.getIndex()].get(currentState.getIndex());
    }

    public IFAState getInitialState() {
        return this.dfaStateList.get(0);
    }

    public int getStateSize() {
        return this.dfaStateList.size();
    }

    public IFAState getState(int index) {
        return this.dfaStateList.get(index);
    }
}

