/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.executable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.commons.trigger.exception.TriggerJarTooLargeException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutableManager.class);
    protected static final String INSTALL_DIR = "install";
    protected final String temporaryLibRoot;
    protected final String libRoot;
    protected final AtomicLong requestCounter;

    public ExecutableManager(String temporaryLibRoot, String libRoot) {
        this.temporaryLibRoot = temporaryLibRoot;
        this.libRoot = libRoot;
        this.requestCounter = new AtomicLong(0L);
    }

    public ExecutableResource request(List<String> uris) throws URISyntaxException, IOException {
        long requestId = this.generateNextRequestId();
        this.downloadExecutables(uris, requestId);
        return new ExecutableResource(requestId, this.getDirStringUnderTempRootByRequestId(requestId));
    }

    private synchronized long generateNextRequestId() throws IOException {
        long requestId = this.requestCounter.getAndIncrement();
        while (FileUtils.isDirectory((File)this.getDirUnderTempRootByRequestId(requestId), (LinkOption[])new LinkOption[0])) {
            requestId = this.requestCounter.getAndIncrement();
        }
        FileUtils.forceMkdir((File)this.getDirUnderTempRootByRequestId(requestId));
        return requestId;
    }

    private void downloadExecutables(List<String> uris, long requestId) throws IOException, URISyntaxException {
        try {
            for (String uriString : uris) {
                URL url = new URI(uriString).toURL();
                String fileName = uriString.substring(uriString.lastIndexOf("/") + 1);
                String destination = this.temporaryLibRoot + File.separator + requestId + File.separator + fileName;
                FileUtils.copyURLToFile((URL)url, (File)FSFactoryProducer.getFSFactory().getFile(destination));
            }
        }
        catch (Exception e) {
            this.removeFromTemporaryLibRoot(requestId);
            throw e;
        }
    }

    public void moveFileUnderTempRootToExtLibDir(ExecutableResource resource, String name) throws IOException {
        FileUtils.moveFileToDirectory((File)this.getFileByFullPath(this.getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + name), (File)this.getFileByFullPath(this.libRoot), (boolean)false);
    }

    public void copyFileToExtLibDir(String filePath) throws IOException {
        FileUtils.copyFileToDirectory((File)FSFactoryProducer.getFSFactory().getFile(filePath), (File)FSFactoryProducer.getFSFactory().getFile(this.libRoot));
    }

    public void removeFileUnderLibRoot(String fileName) throws IOException {
        Path path = Paths.get(this.libRoot + File.separator + fileName, new String[0]);
        Files.deleteIfExists(path);
    }

    public boolean hasFileUnderLibRoot(String fileName) {
        return Files.exists(Paths.get(this.libRoot + File.separator + fileName, new String[0]), new LinkOption[0]);
    }

    public boolean hasFileUnderInstallDir(String fileName) {
        return Files.exists(Paths.get(this.libRoot + File.separator + INSTALL_DIR + File.separator + fileName, new String[0]), new LinkOption[0]);
    }

    public boolean hasFileUnderTemporaryRoot(String fileName) {
        return Files.exists(Paths.get(this.temporaryLibRoot + File.separator + fileName, new String[0]), new LinkOption[0]);
    }

    private void removeFromTemporaryLibRoot(long requestId) {
        FileUtils.deleteQuietly((File)this.getDirUnderTempRootByRequestId(requestId));
    }

    public void saveTextAsFileUnderTemporaryRoot(String text, String fileName) throws IOException {
        Path path = Paths.get(this.temporaryLibRoot + File.separator + fileName, new String[0]);
        Files.deleteIfExists(path);
        Files.write(path, text.getBytes(), new OpenOption[0]);
    }

    public void removeFileUnderTemporaryRoot(String fileName) throws IOException {
        Path path = Paths.get(this.temporaryLibRoot + File.separator + fileName, new String[0]);
        Files.deleteIfExists(path);
    }

    public String readTextFromFileUnderTemporaryRoot(String fileName) throws IOException {
        Path path = Paths.get(this.temporaryLibRoot + File.separator + fileName, new String[0]);
        return new String(Files.readAllBytes(path));
    }

    public File getDirUnderTempRootByRequestId(long requestId) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringUnderTempRootByRequestId(requestId));
    }

    public String getDirStringUnderTempRootByRequestId(long requestId) {
        return this.temporaryLibRoot + File.separator + requestId + File.separator;
    }

    public File getDirUnderLibRootByName(String name) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringUnderLibRootByName(name));
    }

    public String getDirStringUnderLibRootByName(String name) {
        return this.libRoot + File.separator + name + File.separator;
    }

    public File getFileUnderLibRootByName(String name) {
        return FSFactoryProducer.getFSFactory().getFile(this.getFileStringUnderLibRootByName(name));
    }

    public String getFileStringUnderLibRootByName(String name) {
        return this.libRoot + File.separator + name;
    }

    public String getFileStringUnderInstallByName(String name) {
        return this.libRoot + File.separator + INSTALL_DIR + File.separator + name;
    }

    private File getFileByFullPath(String path) {
        return FSFactoryProducer.getFSFactory().getFile(path);
    }

    public static ByteBuffer transferToBytebuffer(String filePath) throws IOException {
        ByteBuffer byteBuffer;
        block9: {
            FileChannel fileChannel = FileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ);
            try {
                long size = fileChannel.size();
                if (size > Integer.MAX_VALUE) {
                    throw new TriggerJarTooLargeException(String.format("Size of file exceed %d bytes", Integer.MAX_VALUE));
                }
                ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)size);
                fileChannel.read(byteBuffer2);
                byteBuffer2.flip();
                byteBuffer = byteBuffer2;
                if (fileChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Error occurred during transferring file{} to ByteBuffer, the cause is {}", (Object)filePath, (Object)e);
                    throw e;
                }
            }
            fileChannel.close();
        }
        return byteBuffer;
    }

    protected void saveToDir(ByteBuffer byteBuffer, String destination) throws IOException {
        try {
            Path path = Paths.get(destination, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            try (FileOutputStream outputStream = new FileOutputStream(destination);){
                outputStream.getChannel().write(byteBuffer);
                outputStream.getFD().sync();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error occurred during writing bytebuffer to {} , the cause is {}", (Object)destination, (Object)e);
            throw e;
        }
    }

    public void saveToLibDir(ByteBuffer byteBuffer, String fileName) throws IOException {
        String destination = this.libRoot + File.separator + fileName;
        this.saveToDir(byteBuffer, destination);
    }

    public void saveToInstallDir(ByteBuffer byteBuffer, String fileName) throws IOException {
        String destination = this.libRoot + File.separator + INSTALL_DIR + File.separator + fileName;
        this.saveToDir(byteBuffer, destination);
    }

    public String getTemporaryLibRoot() {
        return this.temporaryLibRoot;
    }

    public String getLibRoot() {
        return this.libRoot;
    }

    public String getInstallDir() {
        return this.libRoot + File.separator + INSTALL_DIR;
    }
}

