/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils.validate;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;

public class TsFileResourceValidator
implements TsFileValidator {
    private TsFileResourceValidator() {
    }

    @Override
    public boolean validateTsFile(TsFileResource resource) {
        return TsFileResourceUtils.validateTsFileResourceCorrectness(resource);
    }

    @Override
    public boolean validateTsFiles(List<TsFileResource> resourceList) {
        for (TsFileResource resource : resourceList) {
            if (this.validateTsFile(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validateTsFilesIsHasNoOverlap(List<TsFileResource> resourceList) {
        return TsFileResourceUtils.validateTsFileResourcesHasNoOverlap(resourceList);
    }

    public static TsFileResourceValidator getInstance() {
        return ResourceOnlyCompactionValidatorHolder.INSTANCE;
    }

    private static class ResourceOnlyCompactionValidatorHolder {
        private static final TsFileResourceValidator INSTANCE = new TsFileResourceValidator();

        private ResourceOnlyCompactionValidatorHolder() {
        }
    }
}

