/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.ModificationReader;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.ModificationWriter;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTextModificationAccessor
implements ModificationReader,
ModificationWriter,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LocalTextModificationAccessor.class);
    private static final String SEPARATOR = ",";
    private static final String NO_MODIFICATION_MSG = "No modification has been written to this file[{}]";
    private final String filePath;
    private FileOutputStream fos;

    public LocalTextModificationAccessor(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Collection<Modification> read() {
        ArrayList<Modification> result = new ArrayList<Modification>();
        Iterator<Modification> iterator = this.getModificationIterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public Iterator<Modification> getModificationIterator() {
        BufferedReader reader;
        File file = FSFactoryProducer.getFSFactory().getFile(this.filePath);
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            logger.debug(NO_MODIFICATION_MSG, (Object)file);
            return new Iterator<Modification>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Modification next() {
                    throw new NoSuchElementException();
                }
            };
        }
        final Modification[] cachedModification = new Modification[1];
        return new Iterator<Modification>(){

            @Override
            public boolean hasNext() {
                try {
                    if (cachedModification[0] == null) {
                        String line = reader.readLine();
                        if (line == null) {
                            reader.close();
                            return false;
                        }
                        return LocalTextModificationAccessor.this.decodeModificationAndCache(reader, cachedModification, line);
                    }
                }
                catch (IOException e) {
                    logger.warn("An error occurred when reading modifications", (Throwable)e);
                }
                return true;
            }

            @Override
            public Modification next() {
                if (cachedModification[0] == null) {
                    throw new NoSuchElementException();
                }
                Modification result = cachedModification[0];
                cachedModification[0] = null;
                return result;
            }
        };
    }

    private boolean decodeModificationAndCache(BufferedReader reader, Modification[] cachedModification, String line) throws IOException {
        try {
            cachedModification[0] = LocalTextModificationAccessor.decodeModification(line);
            return true;
        }
        catch (IOException e) {
            logger.warn("An error occurred when decode line-[{}] to modification", (Object)line);
            cachedModification[0] = null;
            reader.close();
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fos != null) {
            this.fos.close();
            this.fos = null;
        }
    }

    @Override
    public void force() throws IOException {
        this.fos.flush();
        this.fos.getFD().sync();
    }

    @Override
    public void write(Modification mod) throws IOException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(this.filePath, true);
        }
        this.fos.write(LocalTextModificationAccessor.encodeModification(mod).getBytes());
        this.fos.write(System.lineSeparator().getBytes());
        this.force();
    }

    public void writeInComplete(Modification mod) throws IOException {
        String line;
        if (this.fos == null) {
            this.fos = new FileOutputStream(this.filePath, true);
        }
        if ((line = LocalTextModificationAccessor.encodeModification(mod)) != null) {
            this.fos.write(line.substring(0, 2).getBytes());
            this.force();
        }
    }

    public void writeMeetException(Modification mod) throws IOException {
        if (this.fos == null) {
            this.fos = new FileOutputStream(this.filePath, true);
        }
        this.writeInComplete(mod);
        throw new IOException();
    }

    @Override
    public void truncate(long size) {
        try (FileOutputStream outputStream = new FileOutputStream(FSFactoryProducer.getFSFactory().getFile(this.filePath), true);){
            outputStream.getChannel().truncate(size);
            logger.warn("The modifications[{}] will be truncated to size {}.", (Object)this.filePath, (Object)size);
        }
        catch (FileNotFoundException e) {
            logger.debug(NO_MODIFICATION_MSG, (Object)this.filePath);
        }
        catch (IOException e) {
            logger.error("An error occurred when truncating modifications[{}] to size {}.", new Object[]{this.filePath, size, e});
        }
    }

    @Override
    public void mayTruncateLastLine() {
        try (RandomAccessFile file = new RandomAccessFile(this.filePath, "r");){
            long filePointer;
            if (filePointer == 0L) {
                return;
            }
            file.seek(filePointer);
            byte lastChar = file.readByte();
            if (lastChar != 10) {
                for (filePointer = file.length() - 1L; filePointer > -1L && lastChar != 10; --filePointer) {
                    file.seek(filePointer);
                    lastChar = file.readByte();
                }
                logger.warn("The last line of Mods is incomplete, will be truncated");
                this.truncate(filePointer + 2L);
            }
        }
        catch (IOException e) {
            logger.error("An error occurred when reading modifications", (Throwable)e);
        }
    }

    private static String encodeModification(Modification mod) {
        if (mod instanceof Deletion) {
            return LocalTextModificationAccessor.encodeDeletion((Deletion)mod);
        }
        return null;
    }

    private static Modification decodeModification(String src) throws IOException {
        String[] fields = src.split(SEPARATOR);
        if (Modification.Type.DELETION.name().equals(fields[0])) {
            return LocalTextModificationAccessor.decodeDeletion(fields);
        }
        throw new IOException("Unknown modification type: " + fields[0]);
    }

    private static String encodeDeletion(Deletion del) {
        return (Object)((Object)del.getType()) + SEPARATOR + del.getPathString() + SEPARATOR + del.getFileOffset() + SEPARATOR + del.getStartTime() + SEPARATOR + del.getEndTime();
    }

    private static Deletion decodeDeletion(String[] fields) throws IOException {
        long startTimestamp;
        long endTimestamp;
        long tsFileOffset;
        if (fields.length < 4) {
            throw new IOException("Incorrect deletion fields number: " + fields.length);
        }
        String path = "";
        try {
            tsFileOffset = Long.parseLong(fields[fields.length - 3]);
        }
        catch (NumberFormatException e) {
            return LocalTextModificationAccessor.decodePointDeletion(fields);
        }
        try {
            endTimestamp = Long.parseLong(fields[fields.length - 1]);
            startTimestamp = Long.parseLong(fields[fields.length - 2]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid timestamp: " + e.getMessage());
        }
        try {
            CharSequence[] pathArray = Arrays.copyOfRange(fields, 1, fields.length - 3);
            path = String.join((CharSequence)SEPARATOR, pathArray);
            return new Deletion(new PartialPath(path), tsFileOffset, startTimestamp, endTimestamp);
        }
        catch (IllegalPathException e) {
            throw new IOException("Invalid series path: " + path);
        }
    }

    private static Deletion decodePointDeletion(String[] fields) throws IOException {
        long versionNum;
        long endTimestamp;
        String path = "";
        try {
            endTimestamp = Long.parseLong(fields[fields.length - 1]);
            versionNum = Long.parseLong(fields[fields.length - 2]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid timestamp: " + e.getMessage());
        }
        try {
            CharSequence[] pathArray = Arrays.copyOfRange(fields, 1, fields.length - 2);
            path = String.join((CharSequence)SEPARATOR, pathArray);
            return new Deletion(new PartialPath(path), versionNum, endTimestamp);
        }
        catch (IllegalPathException e) {
            throw new IOException("Invalid series path: " + path);
        }
    }
}

