/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatistic;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.PrintUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.TimePartitionProcessTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.TimePartitionProcessWorker;
import org.apache.iotdb.tsfile.utils.Pair;

public class OverlapStatisticTool {
    private static final String WORKER_NUM_ARG = "worker_num";
    public static final int DEFAULT_WORKER_NUM = 4;
    private static final String SUB_TASK_NUM_ARG = "sub_task_num";
    public static final int DEFAULT_WORKER_SUB_TASK_NUM = 1;
    private static final String DATA_DIRS_ARG = "data_dirs";
    public static int workerNum;
    public static int subTaskNum;
    public static List<String> dataDirs;
    public static Lock outputInfolock;
    public static long seqFileCount;
    public static long processedTimePartitionCount;
    public static long processedSeqFileCount;
    public static final Map<String, Pair<List<String>, List<String>>> timePartitionFileMap;

    public static void main(String[] args) throws InterruptedException {
        OverlapStatisticTool.parseArgs(args);
        OverlapStatisticTool tool = new OverlapStatisticTool();
        long startTime = System.currentTimeMillis();
        tool.process(dataDirs);
        System.out.printf("Total time cost: %.2fs\n", ((double)System.currentTimeMillis() - (double)startTime) / 1000.0);
    }

    public static void parseArgs(String[] args) {
        CommandLine commandLine;
        Options options = OverlapStatisticTool.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        workerNum = Integer.parseInt(OverlapStatisticTool.getArgOrDefault(commandLine, WORKER_NUM_ARG, String.valueOf(4)));
        subTaskNum = Integer.parseInt(OverlapStatisticTool.getArgOrDefault(commandLine, SUB_TASK_NUM_ARG, String.valueOf(1)));
        String[] dataDirsParam = commandLine.getOptionValues(DATA_DIRS_ARG);
        if (dataDirsParam == null || dataDirsParam.length == 0) {
            throw new RuntimeException("data_dirs must not be empty");
        }
        dataDirs = Arrays.asList(dataDirsParam);
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(Option.builder().argName(WORKER_NUM_ARG).longOpt(WORKER_NUM_ARG).hasArg().desc("Concurrent time partition num(default: 10)").build()).addOption(Option.builder().argName(SUB_TASK_NUM_ARG).longOpt(SUB_TASK_NUM_ARG).hasArg().desc("Concurrent file num in one time partition(default: 10)").build()).addOption(Option.builder().argName(DATA_DIRS_ARG).longOpt(DATA_DIRS_ARG).hasArg().desc("Data dirs(Required)").required().build());
        return options;
    }

    private static String getArgOrDefault(CommandLine commandLine, String arg, String defaultValue) {
        String value = commandLine.getOptionValue(arg);
        return value == null ? defaultValue : value;
    }

    public void process(List<String> dataDirs) throws InterruptedException {
        this.processDataDirs(dataDirs);
        int workerNum = Math.min(timePartitionFileMap.size(), OverlapStatisticTool.workerNum);
        TimePartitionProcessWorker[] workers = this.constructWorkers(workerNum);
        CountDownLatch countDownLatch = new CountDownLatch(workerNum);
        for (TimePartitionProcessWorker worker : workers) {
            worker.run(countDownLatch);
        }
        countDownLatch.await();
        OverlapStatistic statistic = new OverlapStatistic();
        for (TimePartitionProcessWorker worker : workers) {
            for (OverlapStatistic partialRet : worker.getWorkerResults()) {
                statistic.merge(partialRet);
            }
        }
        PrintUtil.printOneStatistics(statistic, "All EXECUTED");
    }

    public TimePartitionProcessWorker[] constructWorkers(int workerNum) {
        TimePartitionProcessWorker[] workers = new TimePartitionProcessWorker[workerNum];
        int workerIdx = 0;
        for (Map.Entry<String, Pair<List<String>, List<String>>> timePartitionFilesEntry : timePartitionFileMap.entrySet()) {
            String timePartition = timePartitionFilesEntry.getKey();
            Pair<List<String>, List<String>> timePartitionFiles = timePartitionFilesEntry.getValue();
            if (workers[workerIdx] == null) {
                workers[workerIdx] = new TimePartitionProcessWorker();
            }
            workers[workerIdx].addTask(new TimePartitionProcessTask(timePartition, timePartitionFiles));
            workerIdx = (workerIdx + 1) % workerNum;
        }
        return workers;
    }

    private void processDataDirs(List<String> dataDirs) {
        for (String dataDirPath : dataDirs) {
            File dataDir = new File(dataDirPath);
            if (!dataDir.exists() || !dataDir.isDirectory()) continue;
            this.processDataDirWithIsSeq(dataDirPath, true);
            this.processDataDirWithIsSeq(dataDirPath, false);
        }
    }

    private void processDataDirWithIsSeq(String dataDirPath, boolean isSeq) {
        String dataDirWithIsSeq = isSeq ? dataDirPath + File.separator + "sequence" : dataDirPath + File.separator + "unsequence";
        File dataDirWithIsSequence = new File(dataDirWithIsSeq);
        if (!dataDirWithIsSequence.exists() || !dataDirWithIsSequence.isDirectory()) {
            System.out.println(dataDirWithIsSequence + " is not a correct path");
            return;
        }
        for (File storageGroupDir : Objects.requireNonNull(dataDirWithIsSequence.listFiles())) {
            if (!storageGroupDir.isDirectory()) continue;
            String storageGroup = storageGroupDir.getName();
            for (File dataRegionDir : Objects.requireNonNull(storageGroupDir.listFiles())) {
                if (!dataRegionDir.isDirectory()) continue;
                String dataRegion = dataRegionDir.getName();
                for (File timePartitionDir : Objects.requireNonNull(dataRegionDir.listFiles())) {
                    if (!timePartitionDir.isDirectory()) continue;
                    String timePartitionKey = this.calculateTimePartitionKey(storageGroup, dataRegion, timePartitionDir.getName());
                    Pair timePartitionFiles = timePartitionFileMap.computeIfAbsent(timePartitionKey, v -> new Pair(new ArrayList(), new ArrayList()));
                    for (File file : Objects.requireNonNull(timePartitionDir.listFiles())) {
                        if (!file.isFile() || !file.getName().endsWith(".tsfile")) continue;
                        String resourceFilePath = file.getAbsolutePath() + ".resource";
                        if (!new File(resourceFilePath).exists()) {
                            System.out.println(resourceFilePath + " is not exist, the tsfile is skipped because it is not closed.");
                            continue;
                        }
                        String filePath = file.getAbsolutePath();
                        if (isSeq) {
                            ((List)timePartitionFiles.left).add(filePath);
                            ++seqFileCount;
                            continue;
                        }
                        ((List)timePartitionFiles.right).add(filePath);
                    }
                }
            }
        }
    }

    private String calculateTimePartitionKey(String storageGroup, String dataRegion, String timePartition) {
        return storageGroup + "-" + dataRegion + "-" + timePartition;
    }

    static {
        outputInfolock = new ReentrantLock();
        seqFileCount = 0L;
        processedTimePartitionCount = 0L;
        processedSeqFileCount = 0L;
        timePartitionFileMap = new HashMap<String, Pair<List<String>, List<String>>>();
    }
}

