/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCompactionEstimator
implements Closeable {
    protected Map<TsFileResource, FileInfo> fileInfoCache = new HashMap<TsFileResource, FileInfo>();
    protected Map<TsFileResource, DeviceTimeIndex> deviceTimeIndexCache = new HashMap<TsFileResource, DeviceTimeIndex>();
    protected IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected long compressionRatio = (long)CompressionRatio.getInstance().getRatio() + 1L;

    protected abstract long calculatingMetadataMemoryCost(CompactionTaskInfo var1);

    protected abstract long calculatingDataMemoryCost(CompactionTaskInfo var1) throws IOException;

    protected CompactionTaskInfo calculatingCompactionTaskInfo(List<TsFileResource> resources) throws IOException {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (TsFileResource resource : resources) {
            FileInfo fileInfo = this.getFileInfoFromCache(resource);
            fileInfoList.add(fileInfo);
        }
        return new CompactionTaskInfo(resources, fileInfoList);
    }

    private FileInfo getFileInfoFromCache(TsFileResource resource) throws IOException {
        if (this.fileInfoCache.containsKey(resource)) {
            return this.fileInfoCache.get(resource);
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(resource.getTsFilePath(), true, false);){
            FileInfo fileInfo = CompactionEstimateUtils.calculateFileInfo(reader);
            this.fileInfoCache.put(resource, fileInfo);
            FileInfo fileInfo2 = fileInfo;
            return fileInfo2;
        }
    }

    protected int calculatingMaxOverlapFileNumInSubCompactionTask(List<TsFileResource> resources) throws IOException {
        HashSet<String> devices = new HashSet<String>();
        ArrayList<DeviceTimeIndex> resourceDevices = new ArrayList<DeviceTimeIndex>(resources.size());
        for (TsFileResource resource2 : resources) {
            DeviceTimeIndex deviceTimeIndex = this.getDeviceTimeIndexFromCache(resource2);
            devices.addAll(deviceTimeIndex.getDevices());
            resourceDevices.add(deviceTimeIndex);
        }
        int maxOverlapFileNumInSubCompactionTask = 1;
        for (String device : devices) {
            List resourcesContainsCurrentDevice = resourceDevices.stream().filter(resource -> !resource.definitelyNotContains(device)).sorted(Comparator.comparingLong(resource -> resource.getStartTime(device))).collect(Collectors.toList());
            if (resourcesContainsCurrentDevice.size() < maxOverlapFileNumInSubCompactionTask) continue;
            long maxEndTimeOfCurrentDevice = Long.MIN_VALUE;
            int overlapFileNumOfCurrentDevice = 0;
            for (DeviceTimeIndex resource3 : resourcesContainsCurrentDevice) {
                long deviceStartTimeInCurrentFile = resource3.getStartTime(device);
                long deviceEndTimeInCurrentFile = resource3.getEndTime(device);
                if (deviceStartTimeInCurrentFile <= maxEndTimeOfCurrentDevice) {
                    maxEndTimeOfCurrentDevice = Math.max(maxEndTimeOfCurrentDevice, deviceEndTimeInCurrentFile);
                    maxOverlapFileNumInSubCompactionTask = Math.max(maxOverlapFileNumInSubCompactionTask, ++overlapFileNumOfCurrentDevice);
                    continue;
                }
                maxEndTimeOfCurrentDevice = deviceEndTimeInCurrentFile;
                overlapFileNumOfCurrentDevice = 1;
            }
            if (maxOverlapFileNumInSubCompactionTask != resources.size()) continue;
            return maxOverlapFileNumInSubCompactionTask;
        }
        return maxOverlapFileNumInSubCompactionTask;
    }

    private DeviceTimeIndex getDeviceTimeIndexFromCache(TsFileResource resource) throws IOException {
        if (this.deviceTimeIndexCache.containsKey(resource)) {
            return this.deviceTimeIndexCache.get(resource);
        }
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof FileTimeIndex) {
            timeIndex = resource.buildDeviceTimeIndex();
        }
        this.deviceTimeIndexCache.put(resource, (DeviceTimeIndex)timeIndex);
        return (DeviceTimeIndex)timeIndex;
    }

    @Override
    public void close() throws IOException {
        this.deviceTimeIndexCache.clear();
        this.fileInfoCache.clear();
    }
}

