/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.List;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    private CompactionScheduler() {
    }

    public static int scheduleCompaction(TsFileManager tsFileManager, long timePartition, CompactionScheduleSummary summary) {
        if (!tsFileManager.isAllowCompaction()) {
            return 0;
        }
        int trySubmitCount = 0;
        try {
            trySubmitCount += CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager, timePartition, summary);
            trySubmitCount += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, true, summary);
            trySubmitCount += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, false, summary);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception occurs when selecting compaction tasks", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return trySubmitCount;
    }

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) {
        CompactionScheduler.scheduleCompaction(tsFileManager, timePartition, new CompactionScheduleSummary());
    }

    public static int scheduleInsertionCompaction(TsFileManager tsFileManager, long timePartition, Phaser insertionTaskPhaser) {
        if (!tsFileManager.isAllowCompaction()) {
            return 0;
        }
        int trySubmitCount = 0;
        try {
            trySubmitCount += CompactionScheduler.tryToSubmitInsertionCompactionTask(tsFileManager, timePartition, insertionTaskPhaser);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception occurs when selecting compaction tasks", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return trySubmitCount;
    }

    public static int tryToSubmitInnerSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, boolean sequence, CompactionScheduleSummary summary) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return 0;
        }
        String storageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICompactionSelector innerSpaceCompactionSelector = sequence ? config.getInnerSequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager) : config.getInnerUnsequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager);
        long startTime = System.currentTimeMillis();
        List<InnerSpaceCompactionTask> innerSpaceTaskList = innerSpaceCompactionSelector.selectInnerSpaceTask(sequence ? tsFileManager.getOrCreateSequenceListByTimePartition(timePartition) : tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        CompactionMetrics.getInstance().updateCompactionTaskSelectionTimeCost(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, System.currentTimeMillis() - startTime);
        int trySubmitCount = 0;
        for (InnerSpaceCompactionTask task : innerSpaceTaskList) {
            if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(task)) continue;
            ++trySubmitCount;
        }
        summary.incrementSubmitTaskNum(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, trySubmitCount);
        return trySubmitCount;
    }

    private static int tryToSubmitInsertionCompactionTask(TsFileManager tsFileManager, long timePartition, Phaser insertionTaskPhaser) throws InterruptedException {
        String dataRegionId;
        if (!config.isEnableInsertionCrossSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(logicalStorageGroupName, dataRegionId = tsFileManager.getDataRegionId(), timePartition, tsFileManager);
        List<CrossCompactionTaskResource> selectedTasks = selector.selectInsertionCrossSpaceTask(tsFileManager.getOrCreateSequenceListByTimePartition(timePartition), tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        if (selectedTasks.isEmpty()) {
            return 0;
        }
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(insertionTaskPhaser, timePartition, tsFileManager, (InsertionCrossCompactionTaskResource)selectedTasks.get(0), tsFileManager.getNextCompactionTaskId());
        insertionTaskPhaser.register();
        if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(task)) {
            insertionTaskPhaser.arrive();
            return 0;
        }
        return 1;
    }

    private static int tryToSubmitCrossSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, CompactionScheduleSummary summary) throws InterruptedException {
        if (!config.isEnableCrossSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICrossSpaceSelector crossSpaceCompactionSelector = config.getCrossCompactionSelector().createInstance(logicalStorageGroupName, dataRegionId, timePartition, tsFileManager);
        List<CrossCompactionTaskResource> taskList = crossSpaceCompactionSelector.selectCrossSpaceTask(tsFileManager.getOrCreateSequenceListByTimePartition(timePartition), tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        List memoryCost = taskList.stream().map(CrossCompactionTaskResource::getTotalMemoryCost).collect(Collectors.toList());
        int trySubmitCount = 0;
        int size = taskList.size();
        for (int i = 0; i < size; ++i) {
            if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(new CrossSpaceCompactionTask(timePartition, tsFileManager, taskList.get(i).getSeqFiles(), taskList.get(i).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), (Long)memoryCost.get(i), tsFileManager.getNextCompactionTaskId()))) continue;
            ++trySubmitCount;
        }
        summary.incrementSubmitTaskNum(CompactionTaskType.CROSS, trySubmitCount);
        return trySubmitCount;
    }
}

