/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.AlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.NonAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class FastCompactionPerformerSubTask
implements Callable<Void> {
    private FastCompactionTaskSummary summary;
    private AbstractCompactionWriter compactionWriter;
    private int subTaskId;
    private Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap;
    private Map<TsFileResource, TsFileSequenceReader> readerCacheMap;
    private final Map<TsFileResource, List<Modification>> modificationCacheMap;
    private List<TsFileResource> sortedSourceFiles;
    private final boolean isAligned;
    private String deviceId;
    private List<String> measurements;
    private List<IMeasurementSchema> measurementSchemas;

    public FastCompactionPerformerSubTask(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, List<String> measurements, String deviceId, FastCompactionTaskSummary summary, int subTaskId) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = subTaskId;
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.isAligned = false;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.sortedSourceFiles = sortedSourceFiles;
        this.measurements = measurements;
        this.summary = summary;
    }

    public FastCompactionPerformerSubTask(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, List<IMeasurementSchema> measurementSchemas, String deviceId, FastCompactionTaskSummary summary) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = 0;
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.isAligned = true;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.sortedSourceFiles = sortedSourceFiles;
        this.measurementSchemas = measurementSchemas;
        this.summary = summary;
    }

    @Override
    public Void call() throws IOException, PageException, WriteProcessException, IllegalPathException {
        if (!this.isAligned) {
            NonAlignedSeriesCompactionExecutor seriesCompactionExecutor = new NonAlignedSeriesCompactionExecutor(this.compactionWriter, this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, this.summary);
            for (String measurement : this.measurements) {
                seriesCompactionExecutor.setNewMeasurement(this.timeseriesMetadataOffsetMap.get(measurement));
                seriesCompactionExecutor.execute();
            }
        } else {
            AlignedSeriesCompactionExecutor seriesCompactionExecutor = new AlignedSeriesCompactionExecutor(this.compactionWriter, this.timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, this.measurementSchemas, this.summary);
            seriesCompactionExecutor.execute();
        }
        return null;
    }
}

