/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.service.DataNode;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.rescon.disk.DirectoryChecker;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBShutdownHook.class);

    public IoTDBShutdownHook() {
        super(ThreadName.IOTDB_SHUTDOWN_HOOK.getName());
    }

    @Override
    public void run() {
        RPCService.getInstance().stop();
        if (SchemaEngineMode.valueOf(CommonDescriptor.getInstance().getConfig().getSchemaEngineMode()).equals((Object)SchemaEngineMode.Rocksdb_based)) {
            SchemaEngine.getInstance().clear();
        }
        CommonDescriptor.getInstance().getConfig().setStopping(true);
        CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
        WALManager.getInstance().waitAllWALFlushed();
        if (!IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            StorageEngine.getInstance().syncCloseAllProcessor();
        }
        WALManager.getInstance().deleteOutdatedFilesInWALNodes();
        if (IoTDBDescriptor.getInstance().getConfig().isClusterMode() && IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            DataRegionConsensusImpl.getInstance().getAllConsensusGroupIds().parallelStream().forEach(id -> {
                try {
                    DataRegionConsensusImpl.getInstance().triggerSnapshot(id);
                }
                catch (ConsensusException e) {
                    logger.warn("Something wrong happened while calling consensus layer's triggerSnapshot API.", (Throwable)e);
                }
            });
        }
        try {
            SchemaRegionConsensusImpl.getInstance().stop();
            DataRegionConsensusImpl.getInstance().stop();
        }
        catch (IOException e) {
            logger.error("Stop ConsensusImpl error in IoTDBShutdownHook", (Throwable)e);
        }
        DirectoryChecker.getInstance().deregisterAll();
        CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.Unknown);
        boolean isReportSuccess = false;
        try (ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            isReportSuccess = client.reportDataNodeShutdown(DataNode.generateDataNodeLocation()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
        }
        catch (ClientManagerException e) {
            logger.error("Failed to borrow ConfigNodeClient", (Throwable)e);
        }
        catch (TException e) {
            logger.error("Failed to report shutdown", (Throwable)e);
        }
        if (!isReportSuccess) {
            logger.error("Reporting DataNode shutdown failed. The cluster will still take the current DataNode as Running for a few seconds.");
        }
        if (logger.isInfoEnabled()) {
            logger.info("IoTDB exits. Jvm memory usage: {}", (Object)MemUtils.bytesCntToStr(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
    }
}

