/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;

public class MappableUDFColumnTransformer
extends ColumnTransformer {
    private final ColumnTransformer[] inputColumnTransformers;
    private final UDTFExecutor executor;

    public MappableUDFColumnTransformer(Type returnType, ColumnTransformer[] inputColumnTransformers, UDTFExecutor executor) {
        super(returnType);
        this.inputColumnTransformers = inputColumnTransformers;
        this.executor = executor;
    }

    @Override
    public void evaluate() {
        for (ColumnTransformer inputColumnTransformer : this.inputColumnTransformers) {
            inputColumnTransformer.tryEvaluate();
        }
        int size = this.inputColumnTransformers.length;
        Column[] columns = new Column[size];
        for (int i = 0; i < size; ++i) {
            columns[i] = this.inputColumnTransformers[i].getColumn();
        }
        int count = this.inputColumnTransformers[0].getColumnCachePositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(count);
        this.executor.execute(columns, builder);
        this.initializeColumnCache(builder.build());
    }

    @Override
    protected void checkType() {
    }

    public ColumnTransformer[] getInputColumnTransformers() {
        return this.inputColumnTransformers;
    }

    @Override
    public void close() {
        this.executor.beforeDestroy();
    }
}

