/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;

public abstract class BinaryColumnTransformer
extends ColumnTransformer {
    protected final ColumnTransformer leftTransformer;
    protected final ColumnTransformer rightTransformer;

    protected BinaryColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType);
        this.leftTransformer = leftTransformer;
        this.rightTransformer = rightTransformer;
        this.checkType();
    }

    @Override
    public void evaluate() {
        this.leftTransformer.tryEvaluate();
        this.rightTransformer.tryEvaluate();
        int positionCount = this.leftTransformer.getColumnCachePositionCount();
        Column leftColumn = this.leftTransformer.getColumn();
        Column rightColumn = this.rightTransformer.getColumn();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(leftColumn, rightColumn, builder, positionCount);
        this.initializeColumnCache(builder.build());
    }

    protected abstract void doTransform(Column var1, Column var2, ColumnBuilder var3, int var4);

    public ColumnTransformer getLeftTransformer() {
        return this.leftTransformer;
    }

    public ColumnTransformer getRightTransformer() {
        return this.rightTransformer;
    }
}

