/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.cq.TimeoutPolicy;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class CreateContinuousQueryStatement
extends Statement
implements IConfigStatement {
    private String cqId;
    private long everyInterval;
    private long boundaryTime = 0L;
    private long startTimeOffset;
    private long endTimeOffset = 0L;
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.BLOCKED;
    private QueryStatement queryBodyStatement;
    private String queryBody;

    public CreateContinuousQueryStatement() {
        this.statementType = StatementType.CREATE_CONTINUOUS_QUERY;
    }

    public String getCqId() {
        return this.cqId;
    }

    public void setCqId(String cqId) {
        this.cqId = cqId;
    }

    public long getEveryInterval() {
        return this.everyInterval;
    }

    public void setEveryInterval(long everyInterval) {
        this.everyInterval = everyInterval;
    }

    public long getBoundaryTime() {
        return this.boundaryTime;
    }

    public void setBoundaryTime(long boundaryTime) {
        this.boundaryTime = boundaryTime;
    }

    public long getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(long startTimeOffset) {
        this.startTimeOffset = startTimeOffset;
    }

    public long getEndTimeOffset() {
        return this.endTimeOffset;
    }

    public void setEndTimeOffset(long endTimeOffset) {
        this.endTimeOffset = endTimeOffset;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public QueryStatement getQueryBodyStatement() {
        return this.queryBodyStatement;
    }

    public void setQueryBodyStatement(QueryStatement queryBodyStatement) {
        this.queryBodyStatement = queryBodyStatement;
    }

    public String getZoneId() {
        return this.queryBodyStatement.getSelectComponent().getZoneId().getId();
    }

    public String getSql() {
        return this.constructFormattedSQL();
    }

    public String getQueryBody() {
        if (this.queryBody == null) {
            this.queryBody = this.queryBodyStatement.constructFormattedSQL();
        }
        return this.queryBody;
    }

    public String constructFormattedSQL() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE CQ ").append(this.cqId).append('\n');
        sqlBuilder.append("RESAMPLE\n");
        sqlBuilder.append('\t').append("EVERY ").append(this.everyInterval).append("ms\n");
        sqlBuilder.append('\t').append("BOUNDARY ").append(this.boundaryTime).append("\n");
        sqlBuilder.append('\t').append("RANGE ").append(this.startTimeOffset).append("ms");
        if (this.endTimeOffset != 0L) {
            sqlBuilder.append(", ").append(this.endTimeOffset).append("ms\n");
        } else {
            sqlBuilder.append("\n");
        }
        sqlBuilder.append("TIMEOUT POLICY ").append(this.timeoutPolicy.toString()).append('\n');
        sqlBuilder.append("BEGIN\n");
        String[] queryBodySlices = this.getQueryBody().split("\n");
        for (int i = 0; i < queryBodySlices.length - 1; ++i) {
            sqlBuilder.append('\t').append(queryBodySlices[i]).append('\n');
        }
        sqlBuilder.append("END\n");
        sqlBuilder.append(";");
        return sqlBuilder.toString();
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_CQ.ordinal()), PrivilegeType.USE_CQ);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateContinuousQuery(this, context);
    }

    public void semanticCheck() {
        if (this.everyInterval < IoTDBDescriptor.getInstance().getConfig().getContinuousQueryMinimumEveryInterval()) {
            throw new SemanticException(String.format("CQ: Every interval [%d] should not be lower than the `continuous_query_minimum_every_interval` [%d] configured.", this.everyInterval, IoTDBDescriptor.getInstance().getConfig().getContinuousQueryMinimumEveryInterval()));
        }
        if (this.startTimeOffset <= 0L) {
            throw new SemanticException("CQ: The start time offset should be greater than 0.");
        }
        if (this.endTimeOffset < 0L) {
            throw new SemanticException("CQ: The end time offset should be greater than or equal to 0.");
        }
        if (this.startTimeOffset <= this.endTimeOffset) {
            throw new SemanticException("CQ: The start time offset should be greater than end time offset.");
        }
        if (this.everyInterval > this.startTimeOffset) {
            throw new SemanticException("CQ: The start time offset should be greater than or equal to every interval.");
        }
        if (!this.queryBodyStatement.isSelectInto()) {
            throw new SemanticException("CQ: The query body misses an INTO clause.");
        }
        GroupByTimeComponent groupByTimeComponent = this.queryBodyStatement.getGroupByTimeComponent();
        if (groupByTimeComponent != null && (groupByTimeComponent.getStartTime() != 0L || groupByTimeComponent.getEndTime() != 0L)) {
            throw new SemanticException("CQ: Specifying time range in GROUP BY TIME clause is prohibited.");
        }
        if (this.queryBodyStatement.getWhereCondition() != null && ExpressionAnalyzer.checkIfTimeFilterExist(this.queryBodyStatement.getWhereCondition().getPredicate())) {
            throw new SemanticException("CQ: Specifying time filters in the query body is prohibited.");
        }
    }
}

