/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.internal;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;

public class InternalCreateMultiTimeSeriesStatement
extends Statement {
    private final Map<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap;

    public InternalCreateMultiTimeSeriesStatement(Map<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap) {
        this.statementType = StatementType.INTERNAL_CREATE_MULTI_TIMESERIES;
        this.deviceMap = deviceMap;
    }

    public Map<PartialPath, Pair<Boolean, MeasurementGroup>> getDeviceMap() {
        return this.deviceMap;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.deviceMap.entrySet().stream().flatMap(entry -> ((MeasurementGroup)((Pair)entry.getValue()).right).getMeasurements().stream().map(arg_0 -> ((PartialPath)((PartialPath)entry.getKey())).concatNode(arg_0))).collect(Collectors.toList());
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInternalCreateMultiTimeSeries(this, context);
    }
}

