/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertRowStatement
extends InsertBaseStatement
implements ISchemaValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertRowStatement.class);
    private static final byte TYPE_RAW_STRING = -1;
    private static final byte TYPE_NULL = -2;
    private long time;
    private Object[] values;
    private boolean isNeedInferType = false;
    private boolean[] measurementIsAligned;

    public InsertRowStatement() {
        this.statementType = StatementType.INSERT;
        this.recordedBeginOfLogicalViewSchemaList = 0;
        this.recordedEndOfLogicalViewSchemaList = 0;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean needInferType) {
        this.isNeedInferType = needInferType;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void fillValues(ByteBuffer buffer) throws QueryProcessException {
        this.values = new Object[this.measurements.length];
        this.dataTypes = new TSDataType[this.measurements.length];
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = (byte)ReadWriteIOUtils.read((ByteBuffer)buffer);
            if (typeNum == -1 || typeNum == -2) {
                this.values[i] = typeNum == -1 ? ReadWriteIOUtils.readString((ByteBuffer)buffer) : null;
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public TTimePartitionSlot getTimePartitionSlot() {
        return TimePartitionUtils.getTimePartitionSlot((long)this.time);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRow(this, context);
    }

    @Override
    public long getMinTime() {
        return this.getTime();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        return this.values[index];
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        if (CommonUtils.checkCanCastType(this.dataTypes[columnIndex], dataType)) {
            LOGGER.warn("Inserting to {}.{} : Cast from {} to {}", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
            this.values[columnIndex] = CommonUtils.castValue(this.dataTypes[columnIndex], dataType, this.values[columnIndex]);
            this.dataTypes[columnIndex] = dataType;
            return true;
        }
        return false;
    }

    public void transferType() throws QueryProcessException {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            if (this.measurementSchemas[i] == null) {
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])));
                }
                this.markFailedMeasurement(i, (Exception)((Object)new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])))));
                continue;
            }
            this.dataTypes[i] = this.measurementSchemas[i].getType();
            try {
                this.values[i] = CommonUtils.parseValue(this.dataTypes[i], this.values[i].toString());
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("data type of {}.{} is not consistent, registered type {}, inserting timestamp {}, value {}", new Object[]{this.devicePath, this.measurements[i], this.dataTypes[i], this.time, this.values[i]});
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw e;
                }
                this.markFailedMeasurement(i, e);
            }
        }
        this.isNeedInferType = false;
    }

    @Override
    public void markFailedMeasurement(int index, Exception cause) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurementIndex2Info == null) {
            this.failedMeasurementIndex2Info = new HashMap();
        }
        InsertBaseStatement.FailedMeasurementInfo failedMeasurementInfo = new InsertBaseStatement.FailedMeasurementInfo(this.measurements[index], this.dataTypes[index], this.values[index], cause);
        this.failedMeasurementIndex2Info.putIfAbsent(index, failedMeasurementInfo);
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.values[index] = null;
    }

    public boolean isNeedSplit() {
        return this.hasLogicalViewNeedProcess();
    }

    public List<InsertRowStatement> getSplitList() {
        if (!this.isNeedSplit()) {
            return Collections.singletonList(this);
        }
        Map<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = this.getMapFromDeviceToMeasurementAndIndex();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : mapFromDeviceToMeasurementAndIndex.entrySet()) {
            List<Pair<String, Integer>> pairList = entry.getValue();
            InsertRowStatement statement = new InsertRowStatement();
            statement.setTime(this.time);
            statement.setNeedInferType(this.isNeedInferType);
            statement.setDevicePath(entry.getKey());
            statement.setAligned(this.isAligned);
            Object[] copiedValues = new Object[pairList.size()];
            String[] measurements = new String[pairList.size()];
            MeasurementSchema[] measurementSchemas = new MeasurementSchema[pairList.size()];
            TSDataType[] dataTypes = new TSDataType[pairList.size()];
            for (int i = 0; i < pairList.size(); ++i) {
                int realIndex = (Integer)pairList.get((int)i).right;
                copiedValues[i] = this.values[realIndex];
                measurements[i] = (String)pairList.get((int)i).left;
                measurementSchemas[i] = this.measurementSchemas[realIndex];
                dataTypes[i] = this.dataTypes[realIndex];
                if (this.measurementIsAligned == null) continue;
                statement.setAligned(this.measurementIsAligned[realIndex]);
            }
            statement.setValues(copiedValues);
            statement.setMeasurements(measurements);
            statement.setMeasurementSchemas(measurementSchemas);
            statement.setDataTypes(dataTypes);
            statement.setFailedMeasurementIndex2Info(this.failedMeasurementIndex2Info);
            insertRowStatementList.add(statement);
        }
        return insertRowStatementList;
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        if (!this.isNeedSplit()) {
            return this;
        }
        List<InsertRowStatement> insertRowStatementList = this.getSplitList();
        if (insertRowStatementList.size() == 1) {
            return insertRowStatementList.get(0);
        }
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsStatement;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        return this;
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAfterSchemaValidation() throws QueryProcessException {
        if (this.isNeedInferType) {
            this.transferType();
        }
    }

    @Override
    public TSDataType getDataType(int index) {
        if (this.isNeedInferType) {
            return TypeInferenceUtils.getPredictedDataType(this.values[index], true);
        }
        return this.dataTypes[index];
    }

    @Override
    public TSEncoding getEncoding(int index) {
        return null;
    }

    @Override
    public CompressionType getCompressionType(int index) {
        return null;
    }

    @Override
    public void validateDeviceSchema(boolean isAligned) {
        this.isAligned = isAligned;
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo) {
        if (this.measurementSchemas == null) {
            this.measurementSchemas = new MeasurementSchema[this.measurements.length];
        }
        if (measurementSchemaInfo == null) {
            this.measurementSchemas[index] = null;
        } else {
            if (measurementSchemaInfo.isLogicalView()) {
                if (this.logicalViewSchemaList == null || this.indexOfSourcePathsOfLogicalViews == null) {
                    this.logicalViewSchemaList = new ArrayList();
                    this.indexOfSourcePathsOfLogicalViews = new ArrayList();
                }
                this.logicalViewSchemaList.add(measurementSchemaInfo.getSchemaAsLogicalViewSchema());
                this.indexOfSourcePathsOfLogicalViews.add(index);
                return;
            }
            this.measurementSchemas[index] = measurementSchemaInfo.getSchemaAsMeasurementSchema();
        }
        if (this.isNeedInferType) {
            return;
        }
        try {
            this.selfCheckDataTypes(index);
        }
        catch (DataTypeMismatchException | PathNotExistException e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo, boolean isAligned) {
        this.validateMeasurementSchema(index, measurementSchemaInfo);
        if (this.measurementIsAligned == null) {
            this.measurementIsAligned = new boolean[this.measurements.length];
            Arrays.fill(this.measurementIsAligned, this.isAligned);
        }
        this.measurementIsAligned[index] = isAligned;
    }

    @Override
    public boolean hasLogicalViewNeedProcess() {
        if (this.indexOfSourcePathsOfLogicalViews == null) {
            return false;
        }
        return !this.indexOfSourcePathsOfLogicalViews.isEmpty();
    }

    @Override
    public List<LogicalViewSchema> getLogicalViewSchemaList() {
        return this.logicalViewSchemaList;
    }

    @Override
    public List<Integer> getIndexListOfLogicalViewPaths() {
        return this.indexOfSourcePathsOfLogicalViews;
    }

    @Override
    public void recordRangeOfLogicalViewSchemaListNow() {
        if (this.logicalViewSchemaList != null) {
            this.recordedBeginOfLogicalViewSchemaList = this.recordedEndOfLogicalViewSchemaList;
            this.recordedEndOfLogicalViewSchemaList = this.logicalViewSchemaList.size();
        }
    }

    @Override
    public Pair<Integer, Integer> getRangeOfLogicalViewSchemaListRecorded() {
        return new Pair((Object)this.recordedBeginOfLogicalViewSchemaList, (Object)this.recordedEndOfLogicalViewSchemaList);
    }
}

