/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TimeDuration;

public class GroupByTimeParameter {
    private long startTime;
    private long endTime;
    private TimeDuration interval;
    private TimeDuration slidingStep;
    private boolean leftCRightO;

    public GroupByTimeParameter() {
    }

    public GroupByTimeParameter(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep, boolean leftCRightO) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.leftCRightO = leftCRightO;
    }

    public GroupByTimeParameter(GroupByTimeComponent groupByTimeComponent) {
        this.startTime = groupByTimeComponent.getStartTime();
        this.endTime = groupByTimeComponent.getEndTime();
        this.interval = groupByTimeComponent.getInterval();
        this.slidingStep = groupByTimeComponent.getSlidingStep();
        this.leftCRightO = groupByTimeComponent.isLeftCRightO();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public TimeDuration getInterval() {
        return this.interval;
    }

    public void setInterval(TimeDuration interval) {
        this.interval = interval;
    }

    public TimeDuration getSlidingStep() {
        return this.slidingStep;
    }

    public void setSlidingStep(TimeDuration slidingStep) {
        this.slidingStep = slidingStep;
    }

    public boolean isLeftCRightO() {
        return this.leftCRightO;
    }

    public void setLeftCRightO(boolean leftCRightO) {
        this.leftCRightO = leftCRightO;
    }

    public boolean hasOverlap() {
        return this.interval.getTotalDuration(TimestampPrecisionUtils.currPrecision) > this.slidingStep.getTotalDuration(TimestampPrecisionUtils.currPrecision);
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.startTime, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)this.endTime, (ByteBuffer)buffer);
        this.interval.serialize(buffer);
        this.slidingStep.serialize(buffer);
        ReadWriteIOUtils.write((Boolean)this.leftCRightO, (ByteBuffer)buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)stream);
        this.interval.serialize(stream);
        this.slidingStep.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.leftCRightO, (OutputStream)stream);
    }

    public static GroupByTimeParameter deserialize(ByteBuffer buffer) {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter();
        groupByTimeParameter.setStartTime(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setEndTime(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setInterval(TimeDuration.deserialize((ByteBuffer)buffer));
        groupByTimeParameter.setSlidingStep(TimeDuration.deserialize((ByteBuffer)buffer));
        groupByTimeParameter.setLeftCRightO(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
        return groupByTimeParameter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByTimeParameter)) {
            return false;
        }
        GroupByTimeParameter other = (GroupByTimeParameter)obj;
        return this.startTime == other.startTime && this.endTime == other.endTime && this.interval.equals((Object)other.interval) && this.slidingStep.equals((Object)other.slidingStep) && this.leftCRightO == other.leftCRightO;
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.interval, this.slidingStep, this.leftCRightO);
    }
}

