/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class SchemaTsBlockUtil {
    private static final long MAX_SIZE = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    private SchemaTsBlockUtil() {
    }

    public static <T> List<TsBlock> transferSchemaResultToTsBlockList(Iterator<T> schemaRegionResultIterator, List<TSDataType> outputDataTypes, BiConsumer<T, TsBlockBuilder> consumer) {
        ArrayList<TsBlock> result = new ArrayList<TsBlock>();
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        while (schemaRegionResultIterator.hasNext()) {
            T schemaRegionResultElement = schemaRegionResultIterator.next();
            consumer.accept(schemaRegionResultElement, tsBlockBuilder);
            if (tsBlockBuilder.getRetainedSizeInBytes() < MAX_SIZE) continue;
            result.add(tsBlockBuilder.build());
            tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        }
        if (!tsBlockBuilder.isEmpty()) {
            result.add(tsBlockBuilder.build());
        }
        return result;
    }
}

