/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class LastQuerySortOperator
implements ProcessOperator {
    private static final int MAX_DETECT_COUNT = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    private TsBlock cachedTsBlock;
    private final int cachedTsBlockSize;
    private int cachedTsBlockRowIndex;
    private final List<Operator> children;
    private final OperatorContext operatorContext;
    private final int inputOperatorsCount;
    private int currentIndex;
    private final TsBlockBuilder tsBlockBuilder;
    private final Comparator<Binary> timeSeriesComparator;
    private TsBlock previousTsBlock;
    private int previousTsBlockIndex = 0;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();

    public LastQuerySortOperator(OperatorContext operatorContext, TsBlock cachedTsBlock, List<Operator> children, Comparator<Binary> timeSeriesComparator) {
        this.cachedTsBlock = cachedTsBlock;
        this.cachedTsBlockSize = cachedTsBlock.getPositionCount();
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.currentIndex = 0;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder();
        this.timeSeriesComparator = timeSeriesComparator;
        this.previousTsBlock = null;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.currentIndex < this.inputOperatorsCount) {
            int endIndex = this.getEndIndex();
            ArrayList listenableFutures = new ArrayList();
            for (int i = this.currentIndex; i < endIndex; ++i) {
                ListenableFuture<?> blocked = this.children.get(i).isBlocked();
                if (blocked.isDone()) continue;
                listenableFutures.add(blocked);
            }
            return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.currentIndex >= this.inputOperatorsCount) {
            if (this.previousTsBlock != null) {
                while (this.previousTsBlockIndex < this.previousTsBlock.getPositionCount()) {
                    if (this.canUseDataFromCachedTsBlock(this.previousTsBlock, this.previousTsBlockIndex)) {
                        LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.cachedTsBlock, this.cachedTsBlockRowIndex++);
                        continue;
                    }
                    LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.previousTsBlock, this.previousTsBlockIndex++);
                }
            }
            TsBlock res = this.cachedTsBlock.subTsBlock(this.cachedTsBlockRowIndex);
            this.cachedTsBlockRowIndex = this.cachedTsBlockSize;
            if (!this.tsBlockBuilder.isEmpty()) {
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, res);
                res = this.tsBlockBuilder.build();
                this.tsBlockBuilder.reset();
            }
            return res;
        }
        return this.buildResult();
    }

    private TsBlock buildResult() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        int endIndex = this.getEndIndex();
        while (this.keepGoing(start, maxRuntime, endIndex)) {
            if (this.prepareData()) {
                return null;
            }
            if (this.previousTsBlockIndex >= this.previousTsBlock.getPositionCount()) continue;
            if (this.canUseDataFromCachedTsBlock(this.previousTsBlock, this.previousTsBlockIndex)) {
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.cachedTsBlock, this.cachedTsBlockRowIndex++);
                continue;
            }
            LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.previousTsBlock, this.previousTsBlockIndex++);
        }
        TsBlock res = this.tsBlockBuilder.build();
        this.tsBlockBuilder.reset();
        return res;
    }

    private boolean keepGoing(long start, long maxRuntime, int endIndex) {
        return System.nanoTime() - start < maxRuntime && (this.currentIndex < endIndex || this.previousTsBlock != null && this.previousTsBlockIndex < this.previousTsBlock.getPositionCount()) && !this.tsBlockBuilder.isFull();
    }

    private boolean prepareData() throws Exception {
        if (this.previousTsBlock == null || this.previousTsBlock.getPositionCount() <= this.previousTsBlockIndex) {
            if (this.children.get(this.currentIndex).hasNextWithTimer()) {
                this.previousTsBlock = this.children.get(this.currentIndex).nextWithTimer();
                this.previousTsBlockIndex = 0;
                if (this.previousTsBlock == null) {
                    return true;
                }
            } else {
                this.children.get(this.currentIndex).close();
                this.children.set(this.currentIndex, null);
            }
            ++this.currentIndex;
        }
        return false;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.currentIndex < this.inputOperatorsCount || this.cachedTsBlockRowIndex < this.cachedTsBlockSize || !this.tsBlockBuilder.isEmpty() || this.previousTsBlock != null && this.previousTsBlockIndex < this.previousTsBlock.getPositionCount();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            if (child == null) continue;
            child.close();
        }
        this.cachedTsBlock = null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + this.cachedTsBlock.getRetainedSizeInBytes();
        long res = 0L;
        for (Operator child : this.children) {
            res = Math.max(res, maxPeekMemory + child.calculateMaxPeekMemory());
        }
        return res;
    }

    @Override
    public long calculateMaxReturnSize() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long childrenMaxReturnSize = 0L;
        long childrenSumRetainedSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
            childrenSumRetainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return this.cachedTsBlock.getRetainedSizeInBytes() + childrenMaxReturnSize + childrenSumRetainedSize;
    }

    private int getEndIndex() {
        return this.currentIndex + Math.min(MAX_DETECT_COUNT, this.inputOperatorsCount - this.currentIndex);
    }

    private boolean canUseDataFromCachedTsBlock(TsBlock tsBlock, int index) {
        return this.cachedTsBlockRowIndex < this.cachedTsBlockSize && LastQueryUtil.compareTimeSeries(this.cachedTsBlock, this.cachedTsBlockRowIndex, tsBlock, index, this.timeSeriesComparator) < 0;
    }
}

