/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.SingleColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class NonOverlappedMultiColumnMerger
implements ColumnMerger {
    private final List<InputLocation> inputLocations;
    private final TimeComparator comparator;
    private int index;

    public NonOverlappedMultiColumnMerger(List<InputLocation> inputLocations, TimeComparator comparator) {
        this.inputLocations = inputLocations;
        this.comparator = comparator;
        this.index = 0;
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, TimeColumnBuilder timeBuilder, long currentEndTime, ColumnBuilder columnBuilder) {
        this.moveToNextIfNecessary(inputTsBlocks);
        SingleColumnMerger.mergeOneColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeBuilder, currentEndTime, columnBuilder, this.inputLocations.get(this.index), this.comparator);
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, long currentTime, ColumnBuilder columnBuilder) {
        this.moveToNextIfNecessary(inputTsBlocks);
        SingleColumnMerger.mergeOneColumn(inputTsBlocks, inputIndex, updatedInputIndex, currentTime, columnBuilder, this.inputLocations.get(this.index));
    }

    private void moveToNextIfNecessary(TsBlock[] inputTsBlocks) {
        if (this.index == this.inputLocations.size() - 1) {
            return;
        }
        while (this.index < this.inputLocations.size() - 1 && inputTsBlocks[this.inputLocations.get(this.index).getTsBlockIndex()] == null) {
            ++this.index;
        }
    }
}

