/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class FloatConstantFill
implements IFill {
    private final float value;
    private final float[] valueArray;

    public FloatConstantFill(float value) {
        this.value = value;
        this.valueArray = new float[]{value};
    }

    @Override
    public Column fill(Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new FloatColumn(1, Optional.empty(), this.valueArray), size);
        }
        float[] array = new float[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getFloat(i);
        }
        return new FloatColumn(size, Optional.empty(), array);
    }
}

