/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeServiceMBean;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeServiceMetrics;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeServiceThriftHandler;
import org.apache.iotdb.db.queryengine.execution.exchange.TsBlockSerdeFactory;
import org.apache.iotdb.db.queryengine.execution.memory.LocalMemoryManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.MPPDataExchangeService;
import org.apache.thrift.server.TServerEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPPDataExchangeService
extends ThriftService
implements MPPDataExchangeServiceMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPPDataExchangeService.class);
    private final MPPDataExchangeManager mppDataExchangeManager;
    private final ExecutorService executorService;

    private MPPDataExchangeService() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        this.executorService = IoTDBThreadPoolFactory.newThreadPool((int)config.getMppDataExchangeCorePoolSize(), (int)config.getMppDataExchangeMaxPoolSize(), (long)config.getMppDataExchangeKeepAliveTimeInMs(), (TimeUnit)TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), (IoTThreadFactory)new IoTThreadFactory(ThreadName.MPP_DATA_EXCHANGE_TASK_EXECUTOR.getName()), (String)ThreadName.MPP_DATA_EXCHANGE_TASK_EXECUTOR.getName());
        this.mppDataExchangeManager = new MPPDataExchangeManager(new LocalMemoryManager(), new TsBlockSerdeFactory(), this.executorService, (IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeMPPDataExchangeServiceClientPoolFactory()));
        LOGGER.info("MPPDataExchangeManager init successfully");
    }

    public void initTProcessor() {
        this.initSyncedServiceImpl(null);
        this.processor = new MPPDataExchangeService.Processor((MPPDataExchangeService.Iface)this.mppDataExchangeManager.getOrCreateMPPDataExchangeServiceImpl());
    }

    public MPPDataExchangeManager getMPPDataExchangeManager() {
        return this.mppDataExchangeManager;
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        try {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.MPP_DATA_EXCHANGE_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new MPPDataExchangeServiceThriftHandler(), config.isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.MPP_DATA_EXCHANGE_RPC_SERVICE.getName());
        MetricService.getInstance().addMetricSet((IMetricSet)new MPPDataExchangeServiceMetrics(this.thriftServiceThread));
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getMppDataExchangePort();
    }

    public ServiceType getID() {
        return ServiceType.MPP_DATA_EXCHANGE_SERVICE;
    }

    public void stop() {
        super.stop();
        this.executorService.shutdown();
    }

    public static MPPDataExchangeService getInstance() {
        return MPPDataExchangeServiceHolder.INSTANCE;
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    private static class MPPDataExchangeServiceHolder {
        private static final MPPDataExchangeService INSTANCE = new MPPDataExchangeService();

        private MPPDataExchangeServiceHolder() {
        }
    }
}

