/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaEntityNode
extends SchemaInternalNode {
    private boolean isAligned;
    private Map<String, SchemaMeasurementNode> aliasChildren;

    public SchemaEntityNode(String name) {
        super(name);
    }

    @Override
    public SchemaNode getChild(String name) {
        SchemaNode node = super.getChild(name);
        if (node != null) {
            return node;
        }
        return this.aliasChildren == null ? null : (SchemaNode)this.aliasChildren.get(name);
    }

    public void addAliasChild(String alias, SchemaMeasurementNode measurementNode) {
        if (this.aliasChildren == null) {
            this.aliasChildren = new HashMap<String, SchemaMeasurementNode>();
        }
        this.aliasChildren.put(alias, measurementNode);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    @Override
    public void replaceChild(String name, SchemaNode newChild) {
        SchemaMeasurementNode measurementNode;
        super.replaceChild(name, newChild);
        if (newChild.isMeasurement() && (measurementNode = newChild.getAsMeasurementNode()).getAlias() != null) {
            this.aliasChildren.replace(name, measurementNode);
        }
    }

    @Override
    public void copyDataTo(SchemaNode schemaNode) {
        if (!schemaNode.isEntity()) {
            return;
        }
        SchemaEntityNode entityNode = schemaNode.getAsEntityNode();
        entityNode.setAligned(this.isAligned);
        if (this.aliasChildren != null) {
            for (SchemaMeasurementNode child : this.aliasChildren.values()) {
                entityNode.addAliasChild(child.getAlias(), child);
            }
        }
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    @Override
    public SchemaEntityNode getAsEntityNode() {
        return this;
    }

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeChildren(outputStream);
        ReadWriteIOUtils.write((byte)this.getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.children.size(), (OutputStream)outputStream);
    }

    public static SchemaEntityNode deserialize(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readString((InputStream)inputStream);
        boolean isAligned = ReadWriteIOUtils.readBool((InputStream)inputStream);
        SchemaEntityNode entityNode = new SchemaEntityNode(name);
        entityNode.setAligned(isAligned);
        return entityNode;
    }
}

